package com.supwisdom.dlpay.framework.util;

import com.supwisdom.dlpay.api.util.HMACUtil;
import com.supwisdom.dlpay.framework.tenant.TenantContext;

public class Signature {
  public static final String SPY_TAC = "DLzJi044R7QHhJCDhpjZId8d";
  private static final String ROOT_STATIC_KEY = "WfFTw42/2JnHP1Qjs4hnMstgANbhRvbXL84rNg==";

  private static String deliveryKey(String tenantId, String factor) {
    return HMACUtil.sha256HMAC(tenantId + factor, ROOT_STATIC_KEY);
  }

  public static String generateTac(String factor, String data) {
    String tenant = TenantContext.getTenantSchema();
    if (tenant == null) {
      throw new IllegalArgumentException("TenantID 未定义");
    }
//    System.out.println("factor="+factor+",data="+data+",tenant="+tenant);
    return HMACUtil.sha256HMAC(deliveryKey(tenant, factor), data).substring(0, 24);
  }
}
