package com.supwisdom.dlpay.framework.util;


import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
  /**
   * 判断字符串是否为空
   */
  public static boolean isEmpty(String str) {
    if (null == str || "".equals(str) || "".equals(str.trim())) {
      return true;
    }
    return false;
  }

  /**
   * 判断List是否为空
   */
  public static boolean isEmpty(List list) {
    if (null == list || list.size() <= 0) {
      return true;
    }
    return false;
  }

  public static boolean equalsIgnoreCase(String str1, String str2) {
    return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
  }

  public static boolean equals(String str1, String str2) {
    return str1 == null ? str2 == null : str1.equals(str2);
  }

  /**
   * 手机号验证
   *
   * @param str
   * @return
   */
  public static boolean isMobile(String str) {
    Pattern p = Pattern.compile("^1[0-9]{10}$"); // 验证手机号
    Matcher m = p.matcher(str);
    return m.matches();
  }

  /**
   * 邮箱格式验证
   */
  public static boolean isEmail(String email) {
    boolean ret = true;
    Pattern pattern = Pattern.compile("^([a-zA-Z0-9]+[_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$");
    final Matcher mat = pattern.matcher(email);
    if (!mat.find()) {
      ret = false;
    }
    return ret;
  }

  /**
   * 身份证格式验证
   *
   * @param str
   * @return
   */
  public static boolean isIdentity(String str) {
    // 中国公民身份证格式：长度为15或18位，最后一位可以为字母
    Pattern pattern = Pattern.compile("(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])");
    final Matcher m = pattern.matcher(str);
    return m.matches();
  }

  /**
   * 除去数组中的空值和签名参数
   *
   * @param sArray 签名参数组
   * @return 去掉空值与签名参数后的新签名参数组
   */
  public static Map<String, String> paraFilter(Map<String, String> sArray) {
    Map<String, String> result = new HashMap<String, String>();
    if (sArray == null || sArray.size() <= 0) {
      return result;
    }
    for (String key : sArray.keySet()) {
      String value = sArray.get(key);
      if (null == value || "".equals(value.trim()) || "null".equalsIgnoreCase(value.trim()) || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) {
        continue;
      }
      result.put(key, value);
    }
    return result;
  }

  /**
   * 把数组所有元素排序，并按照“参数=参数值”的模式用“&”字符拼接成字符串
   *
   * @param params 需要排序并参与字符拼接的参数组
   * @return 拼接后字符串
   */
  public static String createLinkString(Map<String, String> params) {

    List<String> keys = new ArrayList<String>(params.keySet());
    Collections.sort(keys);

    String prestr = "";

    for (int i = 0; i < keys.size(); i++) {
      String key = keys.get(i);
      String value = params.get(key);

      if (i == keys.size() - 1) {//拼接时，不包括最后一个&字符
        prestr = prestr + key + "=" + value;
      } else {
        prestr = prestr + key + "=" + value + "&";
      }
    }

    return prestr;
  }

  public static boolean isCharAndNum(String inputStr) {
    //有问题
    /*Pattern p = Pattern.compile("\\w+");
    Matcher m = p.matcher(inputStr);
    if (m.matches()) {
      // 除字母和数字外还包含其它字符
      return false;
    } else {
      return true;
    }*/
    return true;
  }

  /**
   * 手机号遮掩中间4位
   */
  public static String phoneReplace(String phone) {
    if(phone==null){
      return phone;
    }
    return phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
  }

  /**
   * 邮箱只显示@前面的首位和末位
   */
  public static String emailReplace(String s) {
    return s.replaceAll("(\\w?)(\\w+)(\\w)(@\\w+\\.[a-z]+(\\.[a-z]+)?)", "$1****$3$4");
  }

  /**
   * 名字显示姓
   */
  public static String nameReplace(String s) {
    return s.replaceAll("([\\d\\D]{1})(.*)", "$1**");
  }


  public static String urlAppend(String url, String path) {
    if (url.endsWith("/")) {
      if (path.startsWith("/")) {
        return url + path.substring(1);
      }
      return url + path;
    } else {
      if (path.startsWith("/")) {
        return url + path;
      }
      return url + "/" + path;
    }
  }

  public static void transforToBean(List<String> fields, List<String> columns, Object bean) throws Exception {
    if (null == fields) throw new Exception("fields is null");
    if (null == columns) throw new Exception("columns is null");
    if (fields.size() < columns.size()) throw new Exception("错误的列定义");
    Map<String, String> data = new HashMap<>(0);
    for (int i = 0; i < fields.size(); i++) {
      data.put(fields.get(i), columns.get(i));
    }
    org.apache.commons.beanutils.BeanUtils.populate(bean, data);
  }

  /**
   * 企业营业执照编号有15位和18位，自2016年7月1日后，“三证合一、一照一码”后统一为18位社会信用代码
   * */
  public static boolean checkBusinessLicenseNo(String blno) {
    if (isEmpty(blno)) return false;
    String businessLicenseNo = blno.trim();
    if (businessLicenseNo.length() != 15 && businessLicenseNo.length() != 18) return false; //历史企业注册码15位，社会信用代码长度为18位

    if (businessLicenseNo.length() == 15) {
      Pattern pattern = Pattern.compile("^[0-9A-Za-z]\\w{14}$");
      Matcher match = pattern.matcher(businessLicenseNo);
      return match.matches(); //15位注册码为历史问题，只校验格式
    }

    //18位社会信用代码判断
    Pattern pattern = Pattern.compile("^([0-9ABCDEFGHJKLMNPQRTUWXY]{2})([0-9]{6})([0-9ABCDEFGHJKLMNPQRTUWXY]{9})([0-9Y])$");
    Matcher match = pattern.matcher(businessLicenseNo);
    if (!match.matches()) return false; //社会信用代码校验错误！

    //验证最后一位
    String codeStr = "0123456789ABCDEFGHJKLMNPQRTUWXY"; //字符字典（字符下标为代码字符数值）
    int[] ws = {1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28}; //权值
    String lastChar = businessLicenseNo.substring(businessLicenseNo.length() - 1);
//    String prefixStr = businessLicenseNo.substring(0, businessLicenseNo.length() - 1);
    int sum = 0;
    for (int i = 0; i < 17; i++) {
      sum += (codeStr.indexOf(businessLicenseNo.charAt(i)) * ws[i]);
    }
    int c18 = 31 - (sum % 31);
    if (c18 == 31) {
      if ("0".equals(lastChar)) return true; //第18位为0
    } else {
      //0~30 查字典
      String cs18=String.valueOf(codeStr.charAt(c18)); //c18代表的字符
      if(cs18.equals(lastChar)) return true;
    }
    return false;
  }

  public static boolean isNumber(String inputStr) {
    char[] ch = inputStr.toCharArray();
    for (int i = 0; i < ch.length; i++) {
      if ((ch[i] < '0') || (ch[i] > '9')) {
        return false;
      }
    }
    return true;
  }

  public static boolean isCardphyid(String str) {
    if (null != str && str.matches("^[A-F0-9]+$")) {
      return true;
    }
    return false;
  }

  private static char getBankCardCheckCode(String nonCheckCodeBankCard) {
    if (nonCheckCodeBankCard == null || nonCheckCodeBankCard.trim().length() == 0 || !nonCheckCodeBankCard.matches("\\d+")) {
      //如果传的不是数字返回N
      return 'N';
    }
    char[] chs = nonCheckCodeBankCard.trim().toCharArray();
    int luhmSum = 0;
    for (int i = chs.length - 1, j = 0; i >= 0; i--, j++) {
      int k = chs[i] - '0';
      if (j % 2 == 0) {
        k *= 2;
        k = k / 10 + k % 10;
      }
      luhmSum += k;
    }
    return (luhmSum % 10 == 0) ? '0' : (char) ((10 - luhmSum % 10) + '0');
  }

  /**
   * 判断是否是银行卡号
   * */
  public static boolean isBankcardno(String bankCard) {
    if (bankCard.length() < 15 || bankCard.length() > 19) {
      return false;
    }
    char bit = getBankCardCheckCode(bankCard.substring(0, bankCard.length() - 1));
    if (bit == 'N') {
      return false;
    }
    return bankCard.charAt(bankCard.length() - 1) == bit;
  }


}
