package com.supwisdom.dlpay.portal.dao.impl;

import com.supwisdom.dlpay.framework.jpa.BaseRepository;
import com.supwisdom.dlpay.framework.jpa.Finder;
import com.supwisdom.dlpay.framework.jpa.page.Pagination;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.portal.bean.ArticleSearchBean;
import com.supwisdom.dlpay.portal.dao.ArticleRepository;
import com.supwisdom.dlpay.portal.domain.TBArticle;
import org.hibernate.transform.Transformers;
import org.jetbrains.annotations.NotNull;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ArticleRepositoryImpl  extends BaseRepository implements ArticleRepository {
  @NotNull
  @Override
  public Pagination getArticleList(@NotNull ArticleSearchBean bean) throws ParseException {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
    StringBuilder sql = new StringBuilder("select a.*,c.name columnname from tb_article a left join tb_column c on a.columnid = c.columnid where a.isdelete = '0' ");
    String title = bean.getTitle();
    String status = bean.getStatus();
    String savestartdate = bean.getSavestartdate();
    String saveenddate = bean.getSaveenddate();
    String releasestartdate = bean.getReleasestartdate();
    String releaseenddate = bean.getReleaseenddate();
    int pageno = bean.getPageno();
    int pagesize = bean.getPagesize();
    if (!StringUtil.isEmpty(title)) {
      sql.append(" and a.title like :title");
    }
    if (!StringUtil.isEmpty(status)) {
      sql.append(" and a.status =:status");
    }
    if (!StringUtil.isEmpty(releasestartdate)) {
      sql.append(" and a.releasetime >=:releasestartdate");
    }
    if (!StringUtil.isEmpty(releaseenddate)) {
      sql.append(" and a.releasetime <=:releaseenddate");
    }
    if (!StringUtil.isEmpty(savestartdate)) {
      sql.append(" and a.createtime >=:savestartdate");
    }
    if (!StringUtil.isEmpty(saveenddate)) {
      sql.append(" and a.createtime <=:saveenddate");
    }
    sql.append(" order by a.articleno desc");
    Finder f = Finder.create(sql.toString());
    if (!StringUtil.isEmpty(title)) {
      f.setParameter("title", "%" + title.trim() + "%");
    }
    if (!StringUtil.isEmpty(status)) {
      f.setParameter("status", status);
    }
    if (!StringUtil.isEmpty(releasestartdate)) {
      Timestamp timestamp = new Timestamp(sdf.parse(releasestartdate+"000000").getTime());
      f.setParameter("releasestartdate", timestamp);
    }
    if (!StringUtil.isEmpty(releaseenddate)) {
      Timestamp timestamp = new Timestamp(sdf.parse(releaseenddate+"235959").getTime());
      f.setParameter("releaseenddate", timestamp);
    }
    if (!StringUtil.isEmpty(savestartdate)) {
      Timestamp timestamp = new Timestamp(sdf.parse(savestartdate+"000000").getTime());
      f.setParameter("savestartdate", timestamp);
    }
    if (!StringUtil.isEmpty(saveenddate)) {
      Timestamp timestamp = new Timestamp(sdf.parse(saveenddate+"235959").getTime());
      f.setParameter("saveenddate", timestamp);
    }
    return findNative(f, Transformers.aliasToBean(TBArticle.class), pageno, pagesize);
  }
}
