package com.supwisdom.dlpay.portal.dao.impl;

import com.supwisdom.dlpay.framework.jpa.BaseRepository;
import com.supwisdom.dlpay.framework.jpa.Finder;
import com.supwisdom.dlpay.framework.jpa.page.Pagination;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.portal.bean.ColumnSearchBean;
import com.supwisdom.dlpay.portal.dao.ColumnRepository;
import com.supwisdom.dlpay.portal.domain.TBColumn;
import org.hibernate.transform.Transformers;
import org.jetbrains.annotations.NotNull;

public class ColumnRepositoryImpl extends BaseRepository implements ColumnRepository {
  @NotNull
  @Override
  public Pagination getColumnList(@NotNull ColumnSearchBean bean) {
    StringBuilder sql = new StringBuilder("select s.*,p.name parentname from tb_column s left join tb_column p on s.parentid = p.columnid where 1=1 ");
    String name = bean.getName();
    String code = bean.getCode();
    int pageno = bean.getPageno();
    int pagesize = bean.getPagesize();
    if (!StringUtil.isEmpty(name)) {
      sql.append(" and s.name like :name");
    }
    if (!StringUtil.isEmpty(code)) {
      sql.append(" and s.code like :code");
    }
    sql.append(" order by s.isleaf,s.ordernum");
    Finder f = Finder.create(sql.toString());
    if (!StringUtil.isEmpty(name)) {
      f.setParameter("name", "%" + name.trim() + "%");
    }
    if (!StringUtil.isEmpty(code)) {
      f.setParameter("code", "%" + code.trim() + "%");
    }
    return findNative(f, Transformers.aliasToBean(TBColumn.class), pageno, pagesize);
  }
}
