package com.supwisdom.dlpay.portal.dao.impl;

import com.supwisdom.dlpay.framework.jpa.BaseRepository;
import com.supwisdom.dlpay.framework.jpa.Finder;
import com.supwisdom.dlpay.framework.jpa.page.Pagination;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.portal.bean.FeedbackSearchBean;
import com.supwisdom.dlpay.portal.dao.FeedbackRepository;
import com.supwisdom.dlpay.portal.domain.TBFeedback;
import org.hibernate.transform.Transformers;
import org.jetbrains.annotations.NotNull;

public class FeedbackRepositoryImpl extends BaseRepository implements FeedbackRepository {
  @NotNull
  @Override
  public Pagination getFeedbackList(@NotNull FeedbackSearchBean bean) {
    StringBuilder sql = new StringBuilder("select f.*,p.name username from tb_feedback f left join tb_person p on f.userid = p.userid where 1=1 ");
    String username = bean.getUsername();
    String content = bean.getContent();
    String startdate = bean.getStartdate();
    String enddate = bean.getEnddate();
    String replystatus = bean.getReplystatus();
    int pageno = bean.getPageno();
    int pagesize = bean.getPagesize();
    if (!StringUtil.isEmpty(username)) {
      sql.append(" and p.name like :username");
    }
    if (!StringUtil.isEmpty(content)) {
      sql.append(" and f.content like :content");
    }
    if (!StringUtil.isEmpty(startdate)) {
      sql.append(" and f.fbtime >= :startdate");
    }
    if (!StringUtil.isEmpty(enddate)) {
      sql.append(" and f.fbtime <= :enddate");
    }
    if (!StringUtil.isEmpty(replystatus)) {
      sql.append(" and f.replystatus = :replystatus");
    }
    sql.append(" order by f.fbtime desc");
    Finder f = Finder.create(sql.toString());
    if (!StringUtil.isEmpty(username)) {
      f.setParameter("username", "%" + username.trim() + "%");
    }
    if (!StringUtil.isEmpty(content)) {
      f.setParameter("content", "%" + content.trim() + "%");
    }
    if (!StringUtil.isEmpty(startdate)) {
      f.setParameter("startdate", startdate + "000000");
    }
    if (!StringUtil.isEmpty(enddate)) {
      f.setParameter("enddate", enddate + "235959");
    }
    if (!StringUtil.isEmpty(replystatus)) {
      f.setParameter("replystatus", replystatus);
    }
    return findNative(f, Transformers.aliasToBean(TBFeedback.class), pageno, pagesize);
  }
}
