package com.supwisdom.dlpay.portal.dao.impl;

import com.supwisdom.dlpay.framework.jpa.BaseRepository;
import com.supwisdom.dlpay.framework.jpa.Finder;
import com.supwisdom.dlpay.framework.jpa.page.Pagination;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.portal.bean.MsgTemplateSearchBean;
import com.supwisdom.dlpay.portal.dao.MsgTemplateRepository;
import com.supwisdom.dlpay.portal.domain.TBMsgTemplate;
import org.hibernate.transform.Transformers;
import org.jetbrains.annotations.NotNull;

public class MsgTemplateRepositoryImpl extends BaseRepository implements MsgTemplateRepository {
  @NotNull
  @Override
  public Pagination getMsgTemplateList(@NotNull MsgTemplateSearchBean bean) {
    String title = bean.getTitle();
    String content = bean.getContent();
    int pageno = bean.getPageno();
    int pagesize = bean.getPagesize();
    StringBuilder sql = new StringBuilder("select * from tb_msg_template where 1=1");
    if (!StringUtil.isEmpty(title)) {
      sql.append(" and title like :title");
    }
    if (!StringUtil.isEmpty(content)) {
      sql.append(" and content like :content");
    }
    Finder f = Finder.create(sql.toString());
    if (!StringUtil.isEmpty(title)) {
      f.setParameter("title", "%" + title.trim() + "%");
    }
    if (!StringUtil.isEmpty(content)) {
      f.setParameter("content", "%" + content.trim() + "%");
    }
    return findNative(f, Transformers.aliasToBean(TBMsgTemplate.class), pageno, pagesize);
  }
}
