package com.supwisdom.dlpay.portal.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.sql.Timestamp;


@Entity
@Table(name = "tb_article", indexes = {
    @Index(name = "article_idx1", columnList = "articleno", unique = true),
    @Index(name = "article_idx2", columnList = "title"),
    @Index(name = "article_idx3", columnList = "releasetime,createtime,status")
})
public class TBArticle {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "articleid", nullable = false, length = 32)
  private String articleid;

  @Column(name = "columnid", nullable = false, length = 32)
  private String columnid;

  @Column(name = "articleno", unique = true, nullable = false, length = 20)
  private String articleno;

  @Column(name = "title", nullable = false, length = 50)
  private String title;

  @Lob
  @Column(name = "content", columnDefinition = "TEXT")
  private String content;

  @Column(name = "createtime")
  private Timestamp createtime;

  @Column(name = "updatetime")
  private Timestamp updatetime;

  @Column(name = "releasetime")
  private Timestamp releasetime;

  @Column(name = "operid", length = 32)
  private String operid;

  @Column(name = "hits")
  private Integer hits;

  @Column(name = "islink", length = 1)
  private String islink;

  @Column(name = "isdisplay", length = 1)
  private String isdisplay;

  @Column(name = "isdelete", length = 1)
  private String isdelete;

  @Column(name = "status", length = 20)
  private String status;

  @Transient
  private String columnname;


  public String getArticleid() {
    return articleid;
  }

  public void setArticleid(String articleid) {
    this.articleid = articleid;
  }

  public String getColumnid() {
    return columnid;
  }

  public void setColumnid(String columnid) {
    this.columnid = columnid;
  }

  public String getArticleno() {
    return articleno;
  }

  public void setArticleno(String articleno) {
    this.articleno = articleno;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public Timestamp getCreatetime() {
    return createtime;
  }

  public void setCreatetime(Timestamp createtime) {
    this.createtime = createtime;
  }

  public Timestamp getUpdatetime() {
    return updatetime;
  }

  public void setUpdatetime(Timestamp updatetime) {
    this.updatetime = updatetime;
  }

  public Timestamp getReleasetime() {
    return releasetime;
  }

  public void setReleasetime(Timestamp releasetime) {
    this.releasetime = releasetime;
  }

  public String getOperid() {
    return operid;
  }

  public void setOperid(String operid) {
    this.operid = operid;
  }

  public Integer getHits() {
    return hits;
  }

  public void setHits(Integer hits) {
    this.hits = hits;
  }

  public String getIslink() {
    return islink;
  }

  public void setIslink(String islink) {
    this.islink = islink;
  }

  public String getIsdisplay() {
    return isdisplay;
  }

  public void setIsdisplay(String isdisplay) {
    this.isdisplay = isdisplay;
  }

  public String getIsdelete() {
    return isdelete;
  }

  public void setIsdelete(String isdelete) {
    this.isdelete = isdelete;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getColumnname() {
    return columnname;
  }

  public void setColumnname(String columnname) {
    this.columnname = columnname;
  }
}
