package com.supwisdom.dlpay.portal.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "tb_column")
public class TBColumn {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "columnid", nullable = false, length = 32)
  private String columnid;

  @Column(name = "parentid", length = 32)
  private String parentid;

  @Column(name = "isleaf", length = 1,nullable = false)
  private String isleaf;

  @Column(name = "name", length = 30,unique = true,nullable = false)
  private String name;

  /**
   * 是否需要审核后才能发布
   */
  @Column(name = "needreview", length = 1,nullable = false)
  private String needreview;

  /**
   * 是否公开：游客登录只能查看公开栏目下的文章
   */
  @Column(name = "ispublic", length = 1,nullable = false)
  private String ispublic;

  /**
   * 是否能发布：该栏目下的文章是否能发布
   */
  @Column(name = "publishable", length = 1,nullable = false)
  private String publishable;

  @Column(name = "code", length = 30,unique = true,nullable = false)
  private String code;

  @Column(name = "ordernum")
  private Integer ordernum;

  @Transient
  private String parentname;

  public String getColumnid() {
    return columnid;
  }

  public void setColumnid(String columnid) {
    this.columnid = columnid;
  }

  public String getParentid() {
    return parentid;
  }

  public void setParentid(String parentid) {
    this.parentid = parentid;
  }

  public String getIsleaf() {
    return isleaf;
  }

  public void setIsleaf(String isleaf) {
    this.isleaf = isleaf;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getNeedreview() {
    return needreview;
  }

  public void setNeedreview(String needreview) {
    this.needreview = needreview;
  }

  public String getIspublic() {
    return ispublic;
  }

  public void setIspublic(String ispublic) {
    this.ispublic = ispublic;
  }

  public String getPublishable() {
    return publishable;
  }

  public void setPublishable(String publishable) {
    this.publishable = publishable;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getParentname() {
    return parentname;
  }

  public void setParentname(String parentname) {
    this.parentname = parentname;
  }

  public Integer getOrdernum() {
    return ordernum;
  }

  public void setOrdernum(Integer ordernum) {
    this.ordernum = ordernum;
  }
}
