package com.supwisdom.dlpay.portal.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name = "tb_feedback",
        indexes = {@Index(name = "feedback_idx1",columnList = "userid"),
        @Index(name = "feedback_idx2",columnList = "fbtime,replystatus")})
public class TBFeedback {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "fbid", nullable = false, length = 32)
  private String fbid;
  @Column(name = "userid", nullable = false, length = 32)
  private String userid;
  @Column(name = "content", nullable = false, length = 200)
  private String content;
  @Column(name = "fbtime", length = 14)
  private String fbtime;
  @Column(name = "fbip", length = 32)
  private String fbip;
  @Column(name = "replystatus", length = 1)
  private String replystatus;
  @Transient
  private String username;
  @Transient
  private List<TBAnnex> pictures;

  public String getFbid() {
    return fbid;
  }

  public void setFbid(String fbid) {
    this.fbid = fbid;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public String getFbtime() {
    return fbtime;
  }

  public void setFbtime(String fbtime) {
    this.fbtime = fbtime;
  }

  public String getFbip() {
    return fbip;
  }

  public void setFbip(String fbip) {
    this.fbip = fbip;
  }


  public String getReplystatus() {
    return replystatus;
  }

  public void setReplystatus(String replystatus) {
    this.replystatus = replystatus;
  }


  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public List<TBAnnex> getPictures() {
    return pictures;
  }

  public void setPictures(List<TBAnnex> pictures) {
    this.pictures = pictures;
  }
}
