package com.supwisdom.dlpay.portal.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.List;

@Entity
@Table(name = "tb_resource")
public class TBResource {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "resid", nullable = false, length = 32)
  private String resid;

  @Column(name = "respath", length = 100)
  private String respath;

  @Column(name = "resname", length = 50)
  private String resname;

  @Column(name = "parentid", length = 32)
  private String parentid;

  @Column(name = "isleaf", length = 1)
  private String isleaf;

  @Column(name = "showflag", length = 1)
  private String showflag;

  @Column(name = "ordernum", precision = 3)
  private int ordernum;

  @Column(name = "icon",length = 50)
  private String icon;

  @Transient
  private List<TBResource> children;

  public String getResid() {
    return resid;
  }

  public void setResid(String resid) {
    this.resid = resid;
  }

  public String getRespath() {
    return respath;
  }

  public void setRespath(String respath) {
    this.respath = respath;
  }

  public String getResname() {
    return resname;
  }

  public void setResname(String resname) {
    this.resname = resname;
  }

  public String getParentid() {
    return parentid;
  }

  public void setParentid(String parentid) {
    this.parentid = parentid;
  }

  public String getIsleaf() {
    return isleaf;
  }

  public void setIsleaf(String isleaf) {
    this.isleaf = isleaf;
  }

  public String getShowflag() {
    return showflag;
  }

  public void setShowflag(String showflag) {
    this.showflag = showflag;
  }

  public int getOrdernum() {
    return ordernum;
  }

  public void setOrdernum(int ordernum) {
    this.ordernum = ordernum;
  }

  public String getIcon() {
    return icon;
  }

  public void setIcon(String icon) {
    this.icon = icon;
  }

  public List<TBResource> getChildren() {
    return children;
  }

  public void setChildren(List<TBResource> children) {
    this.children = children;
  }
}
