package com.supwisdom.dlpay.portal.util;

import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import com.supwisdom.dlpay.framework.util.StringUtil;
import org.apache.log4j.Logger;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

/**
 * Created by jov on 2017/1/10.
 */
public class PutImageToServer {
    public static Gson gson = new Gson();
    private static Logger logger = Logger.getLogger(PutImageToServer.class);

    public static boolean postImage(String url, InputStream inputStream) {
        try {
            FormDataMultiPart part = new FormDataMultiPart();
            part.bodyPart(new StreamDataBodyPart("files", inputStream));
            part.bodyPart(new FormDataBodyPart("cm","true"));
            ClientConfig cc = new DefaultClientConfig();
            cc.getClasses().add(MultiPartWriter.class);
            Client c = Client.create(cc);
            c.setConnectTimeout(10 * 1000);
            WebResource resource = c.resource(url);
            ClientResponse response = resource.type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, part);
            logger.error("code=" + response.getStatus() + ",ret=" + response.getEntity(String.class));
            if (response.getStatus() / 100 == 2) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            logger.error("error:",e);
            return false;
        }
    }

    public static ImageBean postBefore(String url) {
        try {
            Client c = Client.create();
            c.setConnectTimeout(10 * 1000);
            WebResource resource = c.resource(url);
            ClientResponse response = resource.get(ClientResponse.class);
            if (response.getStatus() == 200) {
                String ret = response.getEntity(String.class);
                ImageBean imageBean = gson.fromJson(ret, ImageBean.class);
                return imageBean;
            } else {
                logger.error("code=" + response.getStatus() + ",ret=" + response.getEntity(String.class));
                return null;
            }
        } catch (Exception e) {
            logger.error("error:",e);
            return null;
        }
    }

    public static boolean downloadFileFromUrl(String img, File file) {
        if (StringUtil.isEmpty(img) || file == null) {
            return false;
        }
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            URL url = new URL(img);
            DataInputStream dataInputStream = new DataInputStream(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int length;
            while ((length = dataInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
            dataInputStream.close();
            fileOutputStream.close();
            return true;
        } catch (MalformedURLException e) {
            logger.error("error:",e);
        } catch (IOException e) {
            logger.error("error:",e);
        }
        return false;
    }

    @XmlRootElement
    public class ImageBean {
        private String fid;
        private String url;
        private String publicUrl;
        private int count;
        private List<LocalBean> locations;

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPublicUrl() {
            return publicUrl;
        }

        public void setPublicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<LocalBean> getLocations() {
            return locations;
        }

        public void setLocations(List<LocalBean> locations) {
            this.locations = locations;
        }
    }

    @XmlRootElement
    public class LocalBean {
        private String publicUrl;

        public String getPublicUrl() {
            return publicUrl;
        }

        public void setPublicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
        }
    }
}
