package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.framework.dao.DictionaryDao;
import com.supwisdom.dlpay.framework.dao.SubjectDao;
import com.supwisdom.dlpay.framework.dao.TranscodeDao;
import com.supwisdom.dlpay.framework.domain.TDictionary;
import com.supwisdom.dlpay.framework.domain.TSubject;
import com.supwisdom.dlpay.framework.domain.TTranscode;
import com.supwisdom.dlpay.system.service.DictionaryDataService;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DictionaryDataServiceImpl implements DictionaryDataService {
  private final DictionaryDao dictionaryDao;
  private final TranscodeDao transcodeDao;
  private final SubjectDao subjectDao;

  public DictionaryDataServiceImpl(DictionaryDao dictionaryDao,
                                   TranscodeDao transcodeDao,
                                   SubjectDao subjectDao) {
    this.dictionaryDao = dictionaryDao;
    this.transcodeDao = transcodeDao;
    this.subjectDao = subjectDao;
  }

  @Override
  @Cacheable(cacheNames = "dictionary_cache", key = "@tenantHolder.genKey(#dicttype)")
  public List<TDictionary> getDictionaryByDictType(String dicttype) {
    List<TDictionary> list = dictionaryDao.findAllByDicttype(dicttype);
    if (!list.isEmpty()) {
      return list;
    }
    return new ArrayList<>();
  }


  private TDictionary findExistsOrNew(List<TDictionary> list, TDictionary item) {
    for (TDictionary i : list) {
      if (item.getDicttype().equals(i.getDicttype()) && item.getDictval().equals(i.getDictval())) {
        i.setDicttypename(item.getDicttypename());
        i.setDictcaption(item.getDictcaption());
        return i;
      }
    }
    TDictionary newDict = new TDictionary();
    newDict.setDicttype(item.getDicttype());
    newDict.setDictval(item.getDictval());
    newDict.setDictcaption(item.getDictcaption());
    newDict.setDicttypename(item.getDicttypename());
    return newDict;
  }

  @Override
  @CacheEvict(cacheNames = "dictionary_cache", key = "@tenantHolder.genKey(#dicttype)")
  public void refreshCache(String dicttype) {
  }

  @Override
  @CacheEvict(cacheNames = "dictionary_cache", key = "@tenantHolder.getId() + '.*'", allEntries = true)
  public void refreshCache() {

  }

  @Override
  @Cacheable(cacheNames = "dictionary_cache", key = "@tenantHolder.genKey('transcode')")
  public List<TTranscode> getTransCode() {
    List<TTranscode> list = transcodeDao.findAll();
    if (!list.isEmpty()) {
      return list;
    }
    return new ArrayList<>();
  }

  @Override
  @Cacheable(cacheNames = "dictionary_cache", key = "@tenantHolder.genKey('allsubject')")
  public List<TSubject> getAllSubject() {
    return subjectDao.findAllDisplaySubjects();
  }
}
