package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.dao.SourceTypeDao;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.framework.dao.ApiClientDao;
import com.supwisdom.dlpay.framework.domain.TApiClient;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.service.ParamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class ParamServiceImpl implements ParamService {
  @Autowired
  private ApiClientDao apiClientDao;
  @Autowired
  private SourceTypeDao sourceTypeDao;

  @Override
  public TApiClient getApiClientByAppid(String appid) {
    if (!StringUtil.isEmpty(appid)) {
      return apiClientDao.findByAppid(appid.trim());
    }
    return null;
  }

  @Override
  @Cacheable(cacheNames = "dictionary_cache", key = "@tenantHolder.genKey('sourcetype')")
  public List<TSourceType> getAllSourceType() {
    return sourceTypeDao.findAll();
  }

}
