package com.supwisdom.dlpay.util;

public class QrCodeTotpUtil {
    public static String generateTOTP(String seed){
        long X = 5;
        long T0 = 0;
        String steps = "0";
        long time = System.currentTimeMillis() / 1000;
        long T = (time - T0) / X;
        steps = Long.toHexString(T).toUpperCase();
        while (steps.length() < 16) {
            steps = "0" + steps;
        }
        String totp = TOTP.generateTOTP(seed, steps, "8", "HmacSHA256");
        return totp;
    }

    public static String generateTOTP(String seed,String returnDigits){
        long X = 5;
        long T0 = 0;
        String steps = "0";
        long time = System.currentTimeMillis() / 1000;
        long T = (time - T0) / X;
        steps = Long.toHexString(T).toUpperCase();
        while (steps.length() < 16) {
            steps = "0" + steps;
        }
        String totp = TOTP.generateTOTP(seed, steps, returnDigits, "HmacSHA256");
        return totp;
    }

    public static boolean verifyCode(String totp, String secret, int offset) {

        String second = "5";
        long T0 = 0;
        String[] keys = new String[offset * 2 + 1];
        long time = System.currentTimeMillis() / 1000;
        for (int i = 0; i < keys.length; i++) {
            String steps = "0";
            try {
                long T = (time - T0) / Long.parseLong(second);
                steps = Long.toHexString(T + (i - offset)).toUpperCase();
                while (steps.length() < 16) {
                    steps = "0" + steps;
                }
                String key = TOTP.generateTOTP(secret, steps, "8", "HmacSHA256");
                keys[i] = key;
            } catch (final Exception e) {
                System.out.println("Error : " + e);
            }
        }
        for (String key : keys) {
            if (key.equals(totp)) {
                return true;
            }
        }
        return false;
    }
}
