package com.supwisdom.dlpay.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class RSAKeysGenerate {

  public static final String KEY_ALGORITHM = "RSA";
  private static final String PUBLIC_KEY = "RSAPublicKey";
  private static final String PRIVATE_KEY = "RSAPrivateKey";
  private static final String KEY_ALG_MODE = "RSA/ECB/PKCS1Padding";
  /** 密钥大小 */
  private static final int KEY_SIZE = 1024;
  /** *//**
   * RSA最大加密明文大小
   */
  private static final int MAX_ENCRYPT_BLOCK = 117;

  /** *//**
   * RSA最大解密密文大小
   */
  private static final int MAX_DECRYPT_BLOCK = 128;
  /** 默认的安全服务提供者 */
  private static final Provider DEFAULT_PROVIDER = new BouncyCastleProvider();
  public static void main(String[] args) {
    Map<String, Object> keyMap;
    try {
      keyMap = initKey();
      String publicKey = getPublicKey(keyMap);
      System.out.println(publicKey);
      String privateKey = getPrivateKey(keyMap);
      System.out.println(privateKey);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public static String getPublicKey(Map<String, Object> keyMap) throws Exception {
    Key key = (Key) keyMap.get(PUBLIC_KEY);
    byte[] publicKey = key.getEncoded();
    return encryptBASE64(key.getEncoded());
  }

  public static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
    Key key = (Key) keyMap.get(PRIVATE_KEY);
    byte[] privateKey = key.getEncoded();
    return encryptBASE64(key.getEncoded());
  }


  public static String encryptBASE64(byte[] key) throws Exception {
    return Base64.encodeBase64String(key);
  }

  public static Map<String, Object> initKey() throws Exception {
    KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
    keyPairGen.initialize(1024);
    KeyPair keyPair = keyPairGen.generateKeyPair();
    RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();
    RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();
    Map<String, Object> keyMap = new HashMap<String, Object>(2);
    keyMap.put(PUBLIC_KEY, publicKey);
    keyMap.put(PRIVATE_KEY, privateKey);
    return keyMap;
  }

  public static PrivateKey getPrivateKey(final String key) throws Exception {
    byte[] keyBytes = null;
    keyBytes = com.sun.jersey.core.util.Base64.decode(key);
    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
    KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
    PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
    return privateKey;
  }
  public static PublicKey getPublicKey(final String key) throws Exception {
    byte[] keyBytes;
    keyBytes = com.sun.jersey.core.util.Base64.decode(key);
    X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
    KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
    PublicKey publicKey = keyFactory.generatePublic(keySpec);
    return publicKey;
  }

  public static byte[] decrypt(PrivateKey privateKey, byte[] data) throws Exception {
    Cipher cipher = Cipher.getInstance(KEY_ALG_MODE, DEFAULT_PROVIDER);
    cipher.init(Cipher.DECRYPT_MODE, privateKey);

    int inputLen = data.length;
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    int offSet = 0;
    byte[] cache;
    int i = 0;
    // 对数据分段解密
    while (inputLen - offSet > 0) {
      if (inputLen - offSet > MAX_DECRYPT_BLOCK) {
        cache = cipher.doFinal(data, offSet, MAX_DECRYPT_BLOCK);
      } else {
        cache = cipher.doFinal(data, offSet, inputLen - offSet);
      }
      out.write(cache, 0, cache.length);
      i++;
      offSet = i * MAX_DECRYPT_BLOCK;
    }
    byte[] decryptedData = out.toByteArray();
    out.close();
    return decryptedData;

  }
  public static String decryptbyte(PrivateKey privateKey, String encrypttext) {
    if (privateKey == null || StringUtils.isBlank(encrypttext)) {
      return null;
    }
    try {
      byte[] en_data = Base64.decodeBase64(encrypttext);


      byte[] data = decrypt(privateKey, en_data);
      return new String(data);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    return null;
  }
  /**
   * 使用指定的公钥加密数据。
   *
   * @param publicKey 给定的公钥。
   * @param data 要加密的数据。
   * @return 加密后的数据。
   */
  public static byte[] encrypt(PublicKey publicKey, byte[] data) throws Exception {
    Cipher cipher = Cipher.getInstance(KEY_ALG_MODE, DEFAULT_PROVIDER);
    cipher.init(Cipher.ENCRYPT_MODE, publicKey);

    int inputLen = data.length;
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    int offSet = 0;
    byte[] cache;
    int i = 0;
    // 对数据分段加密
    while (inputLen - offSet > 0) {
      if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {
        cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);
      } else {
        cache = cipher.doFinal(data, offSet, inputLen - offSet);
      }
      out.write(cache, 0, cache.length);
      i++;
      offSet = i * MAX_ENCRYPT_BLOCK;
    }
    byte[] encryptedData = out.toByteArray();
    out.close();
    return encryptedData;
  }
  public static byte[] encryptbyte(PublicKey publicKey, String plaintext) {
    if (publicKey == null || plaintext == null) {
      return null;
    }
    byte[] data = plaintext.getBytes();
    try {
      byte[] en_data = encrypt(publicKey, data);
      return en_data;
    } catch (Exception ex) {
      ex.printStackTrace();
    }
    return null;
  }
}
