package com.supwisdom.dlpay.agent.service

import com.supwisdom.dlpay.agent.AgentCode
import com.supwisdom.dlpay.agent.AgentPayService
import com.supwisdom.dlpay.agent.AgentResponse
import com.supwisdom.dlpay.agent.DtlStatus
import com.supwisdom.dlpay.agent.citizencard.DlpayResp
import com.supwisdom.dlpay.agent.citizencard.YnrccRespCode
import com.supwisdom.dlpay.agent.citizencard.YnrccUtil
import com.supwisdom.dlpay.api.domain.TTransactionMain
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

interface CitizencardPayService {
    fun bindCard(bankcardno: String, username: String, idtype: String, idno: String,
            phone: String): DlpayResp

    fun signCard(bankcardno: String, username: String, idtype: String, idno: String, phone: String, transtype: String,captcha:String): DlpayResp

    fun cardPay(shopaccno: String, userid: String, accdate: String, amount: Int, scenario: String, refno: String): DlpayResp

    fun cardPayRefund(refno: String, accdate: String, orignRefno: String, amount: Int): DlpayResp

    fun queryResult(orignRefno: String): DlpayResp

    fun getChkfilename(checkdate: String, merchantBankcardno: String?): DlpayResp

    fun makeSureCheckResult(trxdate: String, transcnt: Int, transamt: Long): DlpayResp

    fun bankCardLoss(bankcardno: String, username: String, idtype: String, idno: String): DlpayResp
}

@Component("citizenCardAgent")
class CitizenCardPayAgent : AgentPayService<DtlStatus> {
    @Autowired
    private lateinit var citizencardPayService: CitizencardPayService

    private fun agentCode(code: String, msg: String?): org.springframework.data.util.Pair<AgentCode, YnrccRespCode> {
        return YnrccUtil.errcode.firstOrNull {
            it.second.code == code
        }?.let {
            org.springframework.data.util.Pair.of(it.first, YnrccRespCode(
                    code, it.second.msg.replace("{message}", msg ?: "未知")
            ))
        } ?: org.springframework.data.util.Pair.of(AgentCode.COMMON_ERROR,
                YnrccRespCode(code, msg ?: "未知"))
    }

    override fun query(transaction: TTransactionMain): AgentResponse<DtlStatus> {
        val resp = citizencardPayService.queryResult(transaction.refno)

        return AgentResponse<DtlStatus>().also {
            val code = agentCode(resp.code, resp.message)
            it.code = code.first
            it.agentCode = code.second.code
            it.agentMsg = code.first.message() + "-" + code.second.msg
            it.agentRefno = resp.bankjourno
            it.dtlStatus = when (resp.status) {
                YnrccUtil.DTL_STATUS_SUCCESS -> DtlStatus.SUCCESS
                YnrccUtil.DTL_STATUS_REFUND -> DtlStatus.REFUND
                YnrccUtil.DTL_STATUS_PART_REFUND -> DtlStatus.PARTIAL_REFUND
                else -> DtlStatus.FAIL
            }
        }
    }
}