package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.dao.CardDao
import com.supwisdom.dlpay.api.domain.TCard
import com.supwisdom.dlpay.api.service.CardService
import com.supwisdom.dlpay.util.ConstantUtil
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import javax.persistence.EntityManager
import javax.persistence.PersistenceContext

@Service
class CardServiceImpl : CardService {
    @Autowired
    lateinit var cardDao: CardDao

    @PersistenceContext
    private lateinit var entityManager: EntityManager

    override fun getBankcardByUserid(userid: String): TCard? {
        return cardDao.findCardByUseridAndCardtype(userid, ConstantUtil.CARDTYPE_BANKCARD)
    }
}