package com.supwisdom.dlpay.api.service.impl

import com.google.gson.Gson
import com.supwisdom.dlpay.api.bean.KafkaXgMessage
import com.supwisdom.dlpay.api.service.KafkaSendMsgService
import com.supwisdom.dlpay.framework.util.DateUtil
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.mobile.dao.MsgDao
import com.supwisdom.dlpay.mobile.domain.TBMsg
import com.supwisdom.dlpay.mobile.service.MobileApiService
import mu.KotlinLogging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.kafka.core.KafkaTemplate
import org.springframework.scheduling.annotation.Async
import org.springframework.stereotype.Service

@Service
class KafkaSendMsgServiceImpl : KafkaSendMsgService {
    val logger = KotlinLogging.logger { }
    @Autowired
    private lateinit var kafkaTemplate: KafkaTemplate<String, String>
    @Autowired
    private lateinit var msgDao: MsgDao
    @Autowired
    private lateinit var mobileApiService: MobileApiService

    val gson = Gson()

    val topic = "jpush-messages"

    @Async("kafkaSendMessageAsyncTask")
    override fun sendJpushMessage(userid: String, title: String, content: String, refno: String, extras: MutableMap<String, String>, tenantId: String?) {
        val musers = mobileApiService.findByUseridAndStatus(userid, TradeDict.STATUS_NORMAL)
        var msg = TBMsg().apply {
            this.content = content
            this.title = title
            this.refno = refno
            this.userid = userid
            this.lastupdate = DateUtil.getNow()
            this.refno = refno
            this.extras = gson.toJson(extras)
        }
        if (musers == null || musers.isEmpty()) {
            msg.pushresult = "没有手机用户，消息未推送"
            msgDao.save(msg)
            return
        }
        msg = msgDao.save(msg)
        var uids = ""
        musers.forEach {
            uids += "${it.uid},"
            var platform = "android"
            if ("ios".equals(it.lastloginplatform, true)) {
                platform = "ios"
            }
            val message = KafkaXgMessage()
            message.alltarget = false
            message.callback = true
            message.content = msg.content
            message.title = msg.title
            message.platform = platform
            message.retries = 3
            extras["refno"] = refno
            message.custom = gson.toJson(extras)
            message.expiretime = DateUtil.getNewTime(DateUtil.getNow(), 300)
            message.gids = it.uid
            if (it.lastloginplatform.isNullOrEmpty()) {
                message.platform = "all"
                kafkaTemplate.send(topic, msg.msgid, gson.toJson(message))
            } else {
                kafkaTemplate.send(topic, msg.msgid, gson.toJson(message))
            }
        }
        msg.pusheduids = uids
        msgDao.save(msg)
    }
}
