package com.supwisdom.dlpay.api.service.impl

import com.google.gson.Gson
import com.supwisdom.dlpay.api.bean.ApiResponse
import com.supwisdom.dlpay.api.service.QRCodeService
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.MD5
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.mobile.service.MobileApiService
import com.supwisdom.dlpay.util.AesUtil
import com.supwisdom.dlpay.util.QrCodeTotpUtil
import com.supwisdom.dlpay.util.QrcodeRawData
import com.supwisdom.dlpay.util.RSAKeysGenerate
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.redis.core.RedisTemplate
import org.springframework.stereotype.Service
import java.time.Duration

@Service
class QRCodeServiceImpl:QRCodeService{
    @Autowired
    private lateinit var systemUtilService: SystemUtilService
    @Autowired
    private lateinit var mobileApiService: MobileApiService
    @Autowired
    lateinit var redisTemplate: RedisTemplate<String, String>

    override fun encodeCode(uid:String): ApiResponse {
        var resp = ApiResponse()
        val rootkey = systemUtilService.getBusinessValue("aes.cfb.rootkey")
        val iv = systemUtilService.getBusinessValue("aes.cfb.iv")
        if (rootkey.isNullOrEmpty()||iv.isNullOrEmpty()) {
            resp.retcode = 1
            resp.retmsg = "秘钥未配置"
            return resp
        }
        val muser = mobileApiService.findUserById(uid)
        if(muser==null||TradeDict.STATUS_NORMAL!=muser.status){
            resp.retcode = 1
            resp.retmsg = "用户不存在或状态异常"
            return resp
        }
        if(muser.userid.isNullOrEmpty()){
            resp.retcode = 1
            resp.retmsg = "用户未绑定身份"
            return resp
        }
        val totp = QrCodeTotpUtil.generateTOTP(muser.secertkey)
        val rowdata = QrcodeRawData()
        rowdata.userid = muser.userid
        rowdata.setTotp(totp)
        val orgData = Gson().toJson(rowdata)
        val publicKey = RSAKeysGenerate.getPublicKey(muser.rsapublic)
        val encdata = org.apache.commons.codec.binary.Base64.encodeBase64String(RSAKeysGenerate.encryptbyte(publicKey, orgData))
        val qrcode = AesUtil.encryptCFB("$uid:$encdata", rootkey, iv, "AES/CFB/NoPadding")

        val key = MD5.encodeByMD5ToURLSafeBase64(qrcode)
        redisTemplate.opsForValue().set(key,qrcode, Duration.ofSeconds(20))
        resp.retcode = 0
        resp.retmsg = key
        return resp
    }
}

