package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.dao.AccountDao
import com.supwisdom.dlpay.api.dao.PersonDao
import com.supwisdom.dlpay.api.dao.PersondtlDao
import com.supwisdom.dlpay.api.dao.PointsAccountDao
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.domain.TPerson
import com.supwisdom.dlpay.api.domain.TPersondtl
import com.supwisdom.dlpay.api.domain.TPointsAccount
import com.supwisdom.dlpay.api.service.UserService
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.util.*
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.domain.PageRequest
import org.springframework.data.domain.Sort
import org.springframework.stereotype.Service

/**
 * Created by shuwei on 2019/4/15.
 */
@Service
class UserServiceImpl : UserService {
    @Autowired
    private lateinit var personDao: PersonDao
    @Autowired
    private lateinit var accountDao: AccountDao
    @Autowired
    private lateinit var pointsAccountDao: PointsAccountDao
    @Autowired
    private lateinit var persondtlDao: PersondtlDao

    override fun findAccountByUserid(userid: String, subjno: String?): TAccount? {
        return if (!StringUtil.isEmpty(subjno)) {
            accountDao.findByUseridAndSubjno(userid, subjno)
        } else {
            accountDao.findByUseridAndSubjno(userid, Subject.SUBJNO_PERSONAL_DEPOSIT)
        }
    }

    override fun findPointsAccountByUserid(userid: String): TPointsAccount? {
        return pointsAccountDao.findByUserid(userid)
    }

    override fun findOnePersonByUserid(userid: String): TPerson {
        return personDao.findByUserid(userid)
                ?: throw TransactionProcessException(TradeErrorCode.ACCOUNT_NOT_EXISTS, "用户<$userid>不存在")
    }

    override fun findPersondtlByUserid(userid: String,pageno:Int): PageResult<TPersondtl> {
        var pageable = PageRequest.of(pageno - 1, 10, Sort.Direction.DESC, "transdate","transtime")
        return PageResult<TPersondtl>(persondtlDao.findByUseridAndStatus(userid,TradeDict.DTL_STATUS_SUCCESS,pageable))
    }

    override fun findPersondtlDetailByUserid(userid: String, billno: String): TPersondtl? {
        var dtl = persondtlDao.findById(billno)
        if(dtl.isPresent){
            if(userid!=dtl.get().userid){
                return null
            }
            return dtl.get()
        }else{
            return null
        }
    }
}