package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.mobile.dao.MsgDao
import mu.KotlinLogging
import org.apache.kafka.clients.consumer.ConsumerRecord
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.kafka.annotation.KafkaListener
import org.springframework.stereotype.Component

interface KafkaSendMsgService {
    fun sendJpushMessage(userid: String, title: String, content: String, refno: String, extras: MutableMap<String, String>, tenantId: String?)
}

@Component
class KafkaMsgListener {
    val logger = KotlinLogging.logger { }
    @Autowired
    private lateinit var msgDao: MsgDao

    @KafkaListener(topics = ["jpush-messages-result"],
            autoStartup = "\${spring.kafka.listen.auto.start:true}",
            groupId = "0")
    fun listen(record: ConsumerRecord<String, String>) {
        logger.debug { "${record.key()},${record.value()}" }
        if (!record.key().isNullOrEmpty()) {
            val opt = msgDao.findById(record.key())
            if (opt.isPresent) {
                val msg = opt.get()
                msg.pushresult = record.value()
                msgDao.save(msg)
                return
            }
        }
    }
}