package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.domain.*
import com.supwisdom.dlpay.framework.util.PageResult
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

/**
 * Created by shuwei on 2019/4/15.
 */
interface UserService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findAccountByUserid(userid: String, subjno:String?): TAccount?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPointsAccountByUserid(userid: String): TPointsAccount?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findOnePersonByUserid(userid: String): TPerson

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPersondtlByUserid(userid:String, pageno :Int) : PageResult<TPersondtl>

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPersondtlDetailByUserid(userid:String, billno :String) : TPersondtl?

}