package com.supwisdom.dlpay.mobile

import com.supwisdom.dlpay.agent.citizencard.YnrccUtil
import com.supwisdom.dlpay.agent.service.CitizencardPayService
import com.supwisdom.dlpay.api.bean.JsonResult
import com.supwisdom.dlpay.api.service.QRCodeService
import com.supwisdom.dlpay.api.service.UserService
import com.supwisdom.dlpay.api.util.MobileNumberCheck
import com.supwisdom.dlpay.framework.core.JwtConfig
import com.supwisdom.dlpay.framework.core.JwtTokenUtil
import com.supwisdom.dlpay.framework.domain.JwtRedis
import com.supwisdom.dlpay.framework.redisrepo.ApiJwtRepository
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.*
import com.supwisdom.dlpay.framework.util.Dictionary
import com.supwisdom.dlpay.mobile.domain.TBMobileUser
import com.supwisdom.dlpay.mobile.service.MobileApiService
import com.supwisdom.dlpay.system.service.DictionaryProxy
import com.supwisdom.dlpay.util.ConstantUtil
import com.supwisdom.dlpay.util.RSAKeysGenerate
import mu.KotlinLogging
import org.apache.commons.lang.StringUtils
import org.jose4j.jwt.ReservedClaimNames
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.redis.core.RedisTemplate
import org.springframework.http.HttpStatus
import org.springframework.http.ResponseEntity
import org.springframework.security.core.GrantedAuthority
import org.springframework.security.core.authority.AuthorityUtils
import org.springframework.security.core.context.SecurityContextHolder
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder
import org.springframework.web.bind.annotation.RequestHeader
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RequestParam
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.multipart.MultipartFile
import java.time.Duration
import java.util.*


@RestController
@RequestMapping("/mobileapi/i")
class ApiInit {
    @Autowired
    lateinit var mobileApiService: MobileApiService
    @Autowired
    lateinit var redisTemplate: RedisTemplate<String, String>
    @Autowired
    lateinit var jwtConfig: JwtConfig
    @Autowired
    lateinit var apiJwtRepository: ApiJwtRepository
    @Autowired
    lateinit var systemUtilService: SystemUtilService
    val logger = KotlinLogging.logger { }

    @RequestMapping("/time")
    fun time(): JsonResult {
        return JsonResult.ok("OK").put("now", System.currentTimeMillis())!!
    }

    @RequestMapping("/test")
    fun test(uid: String): JsonResult {
        return JsonResult.ok("OK").put("uid", uid)!!
    }

    @RequestMapping("/uxy")
    fun xieyi(): JsonResult {
        var page = mobileApiService.findPageById(ConstantUtil.PAGE_USERXIEYI)
        if (page != null) {
            return JsonResult.ok("OK").put("page", page.pageContent)!!
        }
        return JsonResult.error("页面未配置")
    }

    /**
     * 注册或找回时使用的验证码生成接口
     * */
    @RequestMapping("/code")
    fun code(@RequestParam phone: String, @RequestParam type: String?): JsonResult {
        if (phone.isEmpty() || !MobileNumberCheck.isPhone(phone)) {
            return JsonResult.error("手机号不合法")
        }
        val user = mobileApiService.findUserByPhone(phone)
        if (type.isNullOrEmpty() || "new" == type) {
            if (user != null && !user.loginpwd.isEmpty()) {
                return JsonResult.error("该手机号已注册，请登录或找回密码")
            }
        } else {
            if ("find" == type) {
                if (user == null) {
                    return JsonResult.error("手机号不存在，请注册")
                }
            } else {
                return JsonResult.error("类型错误")
            }
        }
        //如果已经发送了
        val temp = redisTemplate.opsForValue().get(phone.plus("_after"))
        if (temp.isNullOrEmpty()) {
            val code = RandomUtils.randomNumber(6)
            logger.error { code }
            //TODO 先发送成功，再放入redis
            redisTemplate.opsForValue().set(phone, code, Duration.ofMinutes(5))
            val rs = mobileApiService.sendSms(phone, code)
            if ("0" != rs.retcode) {
                return JsonResult.error(rs.retmsg)
            }
            redisTemplate.opsForValue().set(phone, code, Duration.ofMinutes(5))
            redisTemplate.opsForValue().set(phone.plus("_after"), code, Duration.ofMinutes(2))
        }
        return JsonResult.ok("验证码已发送")
    }

    /**
     * 注册或找回时使用的验证码校验接口
     * */
    @RequestMapping("/checkcode")
    fun check(@RequestParam phone: String,
              @RequestParam code: String,
              @RequestParam platform: String?,
              @RequestParam uuid: String?): JsonResult {
        val temp = redisTemplate.opsForValue().get(phone)
        if (!temp.isNullOrEmpty()) {
            if (temp != code) {
                return JsonResult.error("验证码错误")
            }
            var user = mobileApiService.findUserByPhone(phone)
            if (user == null) {
                user = TBMobileUser()
                //登录ID和phone一致
                user.loginid = phone
                user.phone = phone
                user.registerplatform = platform
                user.registerdate = DateUtil.getNow()
                user.devuid = uuid
                user.status = TradeDict.STATUS_NORMAL
                user.paypwderror = 0
                user.loginpwderror = 0
                user = mobileApiService.saveUser(user)
            }
            user.status = TradeDict.STATUS_NORMAL
            user.registerplatform = platform
            if(!user.registerplatform.isNullOrEmpty()){
                user.lastloginplatform = user.registerplatform!!.split(",")[1]
            }
            user.devuid = uuid
            user = mobileApiService.saveUser(user)
            val newCode = RandomUtils.getRandomString(30)
            redisTemplate.opsForValue().set(user.uid, newCode, Duration.ofHours(1))
            redisTemplate.delete(phone)
            return JsonResult.ok("OK").put("uid", user.uid)?.put("randcode", newCode)!!
        } else {
            return JsonResult.error(-1, "验证码无效或已过期，请重新获取")
        }
    }

    /**
     * 注册
     * */
    @RequestMapping("/register")
    fun register(@RequestParam id: String,
                 @RequestParam pwd: String,
                 @RequestParam repwd: String,
                 @RequestParam random: String): JsonResult {
        if (random.isEmpty()) {
            return JsonResult.error("信息有误，请返回上一步")
        }
        if (pwd.isEmpty() || repwd.isEmpty() || pwd.length < 6) {
            return JsonResult.error("请重新设置密码，密码不能小于6位字符")
        }
        if (!pwd.matches(Regex("^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,32}$"))) {
            return JsonResult.error("密码必须包含数字和字符，长度6~32位")
        }
        if (pwd != repwd) {
            return JsonResult.error("两次密码不一致")
        }
        val user: TBMobileUser? = mobileApiService.findUserById(id) ?: return JsonResult.error("用户不存在，请注册")
        val code = redisTemplate.opsForValue().get(id)
        if (random != code) {
            return JsonResult.error("信息有误，请返回上一步，并重新发送验证码")
        }
        val encoder = BCryptPasswordEncoder()
        user!!.loginpwd = encoder.encode(pwd)
        val exp = systemUtilService.getSysparaValueAsInt(SysparaUtil.MOBILE_LOGIN_EXPIRE_IN_SECONDS, 60 * 60 * 24 * 3)
        jwtConfig.expiration = exp.toLong()
        val authorities: Collection<GrantedAuthority> = AuthorityUtils.createAuthorityList("ROLE_USER")
        user.auths = authorities
        val token = JwtTokenUtil(jwtConfig).generateToken(
                mapOf("uid" to user.uid, "issuer" to "payapi",
                        "audience" to user.loginid,
                        Constants.JWT_CLAIM_TENANTID to "mobile",
                        Constants.JWT_CLAIM_AUTHORITIES to user.authorities))
        val jwt = JwtRedis().apply {
            jti = token.jti
            uid = user.loginid
            status = TradeDict.JWT_STATUS_NORMAL
            expiration = token.expiration.valueInMillis
        }.apply {
            //删除之前的token
            if (!user.jti.isNullOrEmpty()) {
                apiJwtRepository.deleteById(user.jti!!)
            }
            apiJwtRepository.save(this)
        }
        if (user.loginpwderror > 0) {
            user.loginpwderror = 0
            user.loginpwderrortime = null
        }
        user.lastlogin = DateUtil.getNow()
        user.jti = jwt.jti
        val keyMap = RSAKeysGenerate.initKey()
        val publicKey = RSAKeysGenerate.getPublicKey(keyMap)
        val privateKey = RSAKeysGenerate.getPrivateKey(keyMap)
        user.rsaprivate = privateKey
        user.rsapublic = publicKey
        user.secertkey = RandomUtils.getSecureRandomHex()
        mobileApiService.saveUser(user)
        redisTemplate.delete(user.uid)
        var payseted = false
        if (!user.paypwd.isNullOrEmpty()) {
            payseted = true
        }
        var signed = ""
        if (!user.userid.isNullOrEmpty()) {
            val card = mobileApiService.findCardByUserid(user.userid!!)
            if (card != null && card.signed) {
                signed = TradeDict.STATUS_YES
            }
        }
        return JsonResult.ok("OK").put("token", token.jwtToken)
                ?.put("userid", if (user.userid.isNullOrEmpty()) "" else user.userid)
                ?.put("expire", token.expiration.valueInMillis)
                ?.put("now", System.currentTimeMillis())
                ?.put("phone", StringUtil.phoneReplace(user.phone))
                ?.put("paypwdset", payseted)
                ?.put("signed", signed)
                ?.put("tenantid", "mobile")!!
    }

    /**
     *
     * 小程序认证接口
     *
     * */


}


@RestController
@RequestMapping("/mobileapi/v1")
class ApiV1 {
    @Autowired
    lateinit var mobileApiService: MobileApiService
    @Autowired
    lateinit var userService: UserService
    @Autowired
    lateinit var redisTemplate: RedisTemplate<String, String>
    @Autowired
    lateinit var dictionaryProxy: DictionaryProxy
    @Autowired
    lateinit var citizencardPayService: CitizencardPayService
    @Autowired
    lateinit var apiJwtRepository: ApiJwtRepository
    @Autowired
    lateinit var jwtConfig: JwtConfig
    @Autowired
    lateinit var qrcodeService:QRCodeService
    val logger = KotlinLogging.logger { }

    @RequestMapping("/idtypes")
    fun idtypes(): JsonResult {
        var dict = dictionaryProxy.getDictionaryAsMap(Dictionary.IDTYPE)
        return JsonResult.ok("OK").put("idtypes", dict)!!
    }

    @RequestMapping("/logout")
    fun logout(@RequestHeader("Authorization") auth: String?): ResponseEntity<Any> {
        if (auth == null) {
            return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build()
        }
        val jwt = auth.substring(jwtConfig.tokenHeader.length)
        val claims = JwtTokenUtil(jwtConfig).verifyToken(jwt)
        SecurityContextHolder.clearContext()
        apiJwtRepository.deleteById(claims[ReservedClaimNames.JWT_ID].toString())
        return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build()
    }

    /**
     * 用户信息
     * */
    @RequestMapping("/infor")
    fun getUserInfor(): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        var user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        var tk= ""
        if (!user.jti.isNullOrEmpty()) {
            var opt = apiJwtRepository.findById(user.jti!!)
            if(opt.isPresent){
                var jwt =  opt.get()
                val cur = System.currentTimeMillis()
                //token 小于12个小时，则更新它
                if(jwt.expiration-cur<1000*60*60*12){
                    val token = JwtTokenUtil(jwtConfig).generateToken(
                            mapOf("uid" to user.uid, "issuer" to "payapi",
                                    "audience" to user.loginid,
                                    Constants.JWT_CLAIM_TENANTID to "mobile",
                                    Constants.JWT_CLAIM_AUTHORITIES to p.authorities))
                    jwt = JwtRedis().apply {
                        jti = token.jti
                        uid = user.loginid
                        status = TradeDict.JWT_STATUS_NORMAL
                        expiration = token.expiration.valueInMillis
                    }.apply {
                        //删除之前的token
                        if (!user.jti.isNullOrEmpty()) {
                            apiJwtRepository.deleteById(user.jti!!)
                        }
                        apiJwtRepository.save(this)
                    }
                    user.jti = jwt.jti
                    mobileApiService.saveUser(user)
                    tk = token.jwtToken
                }
            }
        }
        return JsonResult.ok("OK").put("now", System.currentTimeMillis())
                ?.put("token", tk)!!
    }
    /**
     * 验证码生成，内部校验
     * */
    @RequestMapping("/code")
    fun code(): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name) ?: return JsonResult.error("用户不存在，请注册")
        if (user.phone.isNullOrEmpty()) {
            return JsonResult.error("用户不存在，请注册")
        }
        val temp = redisTemplate.opsForValue().get(user.phone!!)
        if (temp.isNullOrEmpty()) {
            val code = RandomUtils.randomNumber(6)
            logger.error { code }
            //TODO delete it in product
            redisTemplate.opsForValue().set(user.loginid, code, Duration.ofMinutes(5))
            val rs = mobileApiService.sendSms(user.phone!!, code)
            if ("0" != rs.retcode) {
                return JsonResult.error(rs.retmsg)
            }
            redisTemplate.opsForValue().set(user.loginid, code, Duration.ofMinutes(5))
        }
        return JsonResult.ok("验证码已发送")
    }

    @RequestMapping("/checkcode")
    fun check(@RequestParam code: String, @RequestParam personid: String?
    ): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (user.phone.isNullOrEmpty()) {
            return JsonResult.error("手机号不存在，请注册")
        }
        val temp = redisTemplate.opsForValue().get(user.phone!!)
        if (!temp.isNullOrEmpty()) {
            if (temp != code) {
                return JsonResult.error("验证码错误")
            }
            val newCode = RandomUtils.getRandomString(30)
            redisTemplate.opsForValue().set(user.uid, newCode, Duration.ofHours(1))
            redisTemplate.delete(user.phone!!)
            if (!personid.isNullOrEmpty()) {
                //绑定用户
                val person = userService.findOnePersonByUserid(personid)
                user.bindtime = DateUtil.getNow()
                user.userid = person.userid
                mobileApiService.saveUser(user)
            }
            return JsonResult.ok("OK").put("randcode", newCode)!!
        } else {
            return JsonResult.error(-1, "验证码无效或已过期，请重新获取")
        }
    }

    /**
     * 绑卡
     * */
    @RequestMapping("/bindcard")
    fun bindcard(cardno: String, name: String, idtype: String, idno: String): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (user.phone.isNullOrEmpty()) {
            return JsonResult.error("手机号不存在，请注册")
        }
        val phone = user.phone!!
        val card = mobileApiService.findCardByNo(cardno)
                ?: return JsonResult.error("银行卡号有误")
        if (card.userid.isNullOrEmpty() || card.status != TradeDict.STATUS_NORMAL) {
            return JsonResult.error("银行卡号信息有误")
        }
        val person = userService.findOnePersonByUserid(card.userid)
        if (person.name != name) {
            return JsonResult.error("绑定信息有误[姓名]")
        }
        if (person.idtype != idtype || person.idno != idno) {
            return JsonResult.error("绑定信息有误[证件类型/证件号]")
        }
        val exsitUser = mobileApiService.findUserById(card.userid)
        if (exsitUser != null) {
            return JsonResult.error("该银行卡号已被绑定，若您本人绑定，请先解除绑定，若非本人，请联系客服")
        }
        var signed = ""
        //call api
        var resp = citizencardPayService.bindCard(cardno, name, idtype, idno, phone)
        if (resp.code != "0000") {
            return JsonResult.error(resp.message)
        }
        var needupdate = false
        if (resp.sinstatus == YnrccUtil.TRANSTYPE_SIGNCARD ) {
            signed = TradeDict.STATUS_YES
            if(!card.signed){
                card.signed = true
                mobileApiService.saveCard(card)
            }
            user.signedtime = DateUtil.getNow();
            mobileApiService.saveUser(user)
            needupdate = true;

        }
        if( user.userid.isNullOrEmpty()){
            user.userid = person.userid
            user.bindtime = DateUtil.getNow()
            needupdate=true
        }
        if(needupdate){
            mobileApiService.saveUser(user)
        }
        var payseted = false
        if (!user.paypwd.isNullOrEmpty()) {
            payseted = true
        }

        return JsonResult.ok("OK").put("personid", card.userid)
                ?.put("paypwdset", payseted)
                ?.put("phonex", StringUtil.phoneReplace(phone))
                ?.put("signed", signed)!!


    }
    /**
     * 绑卡
     * */
    @RequestMapping("/bindcardcode")
    fun bindcardcode(): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (user.phone.isNullOrEmpty()) {
            return JsonResult.error("手机号不存在，请注册")
        }
        var card = mobileApiService.findCardByUserid(user.userid!!)
                ?: return JsonResult.error("卡片不存在，请重新绑定")
        //call sign api
        val person = userService.findOnePersonByUserid(card.userid)
        var signed=""
        //call api
        var resp = citizencardPayService.bindCard(card.cardno, person.name, person.idtype, person.idno, user.phone!!)
        if (resp.code != "0000") {
            return JsonResult.error(resp.message)
        }

        if (resp.sinstatus == YnrccUtil.TRANSTYPE_SIGNCARD ) {
            signed = TradeDict.STATUS_YES
            if(!card.signed){
                card.signed = true
                mobileApiService.saveCard(card)
            }
            user.signedtime = DateUtil.getNow();
            mobileApiService.saveUser(user)
        }

        return JsonResult.ok("OK")
                ?.put("signed", signed)!!

    }

    /**
     * 支付密码
     * */
    @RequestMapping("/paypwd")
    fun paypwd(pwd: String, repwd: String, oldpwd: String?, type: String, randcode: String?): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (pwd != repwd) {
            return JsonResult.error("两次密码不一致，请确认")
        }
        if (pwd.length != 6) {
            return JsonResult.error("支付密码为6位数字")
        }
        if (!StringUtils.isNumeric(pwd)) {
            return JsonResult.error("支付密码为6位数字")
        }
        val encoder = BCryptPasswordEncoder()
        if (user.paypwd.isNullOrEmpty()) {
            user.paypwd = encoder.encode(pwd)
            mobileApiService.saveUser(user)
            return JsonResult.ok("OK")
                    ?.put("paypwdset", true)!!
        } else {
            when (type) {
                "new" -> return JsonResult.error("支付密码已设置")
                "renew" -> {
                    if (oldpwd.isNullOrEmpty()) {
                        return JsonResult.error("原支付密码错误")
                    }
                    val paypwdtimes = user.checkPaypwdtime()
                    if (paypwdtimes == -1) {
                        return JsonResult.error("密码错误次数过多，请30分钟后再试")
                    } else if (paypwdtimes == 1) {
                        mobileApiService.saveUser(user)
                    }
                    if (!encoder.matches(oldpwd, user.paypwd)) {
                        user.updatePaypwderror(false).also {
                            if (it) mobileApiService.saveUser(user)
                        }
                        return JsonResult.error("原支付密码错误")
                    } else {
                        user.updatePaypwderror(true).also {
                            if (it) mobileApiService.saveUser(user)
                        }
                    }
                    user.paypwd = encoder.encode(pwd)
                    mobileApiService.saveUser(user)
                    return JsonResult.ok("OK")
                            ?.put("paypwdset", true)!!
                }
                "find" -> {
                    if (randcode.isNullOrEmpty()) {
                        return JsonResult.error("信息有误，请返回并重新设置")
                    }
                    val code = redisTemplate.opsForValue().get(user.uid)
                    if (randcode != code) {
                        return JsonResult.error(-1, "长时间未操作，请返回上一步，并重新发送验证码")
                    }
                    user.paypwd = encoder.encode(pwd)
                    mobileApiService.saveUser(user)
                    redisTemplate.delete(user.uid)
                    return JsonResult.ok("OK").put("paypwdset", true)!!
                }
                else -> return JsonResult.error("请求错误")
            }
        }
    }

    /**
     *
     * 银行协议
     * */
    @RequestMapping("/bxy")
    fun xieyi(): JsonResult {
        val page = mobileApiService.findPageById(ConstantUtil.PAGE_BANKXIEYI)
        if (page != null) {
            val p = SecurityContextHolder.getContext().authentication
            val user = mobileApiService.findUserById(p.name)
                    ?: return JsonResult.error("用户不存在，请注册")
            var signed = ""
            if (!user.userid.isNullOrEmpty()) {
                var card = mobileApiService.findCardByUserid(user.userid!!)
                        ?: return JsonResult.error(-1, "卡片不存在，请重新绑定")
                if (card.signed) {
                    signed = TradeDict.STATUS_YES
                }
            } else {
                return JsonResult.error(-1, "请先绑定银行卡")
            }
            return JsonResult.ok("OK").put("page", page.pageContent)?.put("signed", signed)!!
        }
        return JsonResult.error("页面未配置")
    }

    /**
     *
     * 签约银行协议
     * */
    @RequestMapping("/signbxy")
    fun signbxy(agree: String): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("手机号不存在，请注册")
        if (user.phone.isNullOrEmpty()) {
            return JsonResult.error("用户不存在，请注册")
        }
        var signed: String
        if (!user.userid.isNullOrEmpty()) {
            var card = mobileApiService.findCardByUserid(user.userid!!)
                    ?: return JsonResult.error("卡片不存在，请重新绑定")
            //call sign api
            val person = userService.findOnePersonByUserid(card.userid)
            val captcha = agree//此处为验证码，暂由此参数代替
            var resp = citizencardPayService.signCard(card.cardno, person.name, person.idtype, person.idno, user.phone!!, YnrccUtil.TRANSTYPE_SIGNCARD,captcha)
            if (resp.code != "0000") {
                return JsonResult.error(resp.message)
            }
            card.signed = true
            user.signedtime = DateUtil.getNow()
            mobileApiService.saveCard(card)
            mobileApiService.saveUser(user)
            signed = TradeDict.STATUS_YES
        } else {
            return JsonResult.error("请先绑定银行卡")
        }
        return JsonResult.ok("ok")
                .put("signed", signed)!!
    }

    /**
     * 查询账单
     * */
    @RequestMapping("/bills")
    fun bills(pageno: Int,platform: String?,type:String?): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        val c = Calendar.getInstance()
        val timeOfDay = c.get(Calendar.HOUR_OF_DAY)
        var t = ""
        when (timeOfDay) {
            in 0..7 -> t = "早上好"
            in 8..12 -> t = "上午好"
            in 13..17 -> t = "下午好"
            in 18..23 -> t = "晚上好"
        }
        if (user.userid.isNullOrEmpty()) {
            return JsonResult.ok("OK").put("t", t)!!
        }
        val no = if (pageno <= 0) 1 else pageno
        val today = DateUtil.getNow("yyyyMMdd")
        val yester = DateUtil.getNowInterDay(-1)
        val acc = userService.findAccountByUserid(user.userid!!, null)
        val point = userService.findPointsAccountByUserid(user.userid!!)
        var amount = 0.0;
        var pi = 0L
        if (acc != null && acc.availbal != null) {
            amount = acc.availbal
        }
        if (point != null && point.points != null) {
            pi = point.points
        }
        var payseted = false
        if (!user.paypwd.isNullOrEmpty()) {
            payseted = true
        }
        val person = userService.findOnePersonByUserid(user.userid!!)
        val card = mobileApiService.findCardByUserid(user.userid!!)
        var needrebind = false
        var signed = ""
        if (card == null) {
            //卡片已补办，或绑定失败，需要重新绑定
            needrebind = true
        } else {
            if (card.signed) {
                signed = TradeDict.STATUS_YES
            }
        }
        var version:String?=""
        var minversion:String?=""
        var versionmsg:String?=""
        var versionurl:String?=""
        if(!platform.isNullOrEmpty()){
            var map= mutableMapOf<String,Any>()
            var key=""
            if(platform.toLowerCase().contains("android")){
                key="androidapp"
                if(!type.isNullOrEmpty()){
                    key+= "_$type"
                }
                dictionaryProxy.refreshDictionary(key)
                map = dictionaryProxy.getDictionaryAsMap(key)
                if(map["androidversion"]!=null){
                    version = map["androidversion"] as String
                }
                if(map["androidminversion"]!=null){
                    minversion = map["androidminversion"] as String
                }
                if(map["androidversionmsg"]!=null){
                    versionmsg = map["androidversionmsg"] as String
                }
                if(map["androidversionurl"]!=null){
                    versionurl = map["androidversionurl"] as String
                }

            }else if(platform.toLowerCase().contains("iphone")){
                key="iosapp"
                if(!type.isNullOrEmpty()){
                    key+= "_$type"
                }
                dictionaryProxy.refreshDictionary(key)
                map = dictionaryProxy.getDictionaryAsMap(key)
                if(map["iosversion"]!=null){
                    version = map["iosversion"] as String
                }
                if(map["iosminversion"]!=null){
                    minversion = map["iosminversion"] as String
                }
                if(map["iosversionmsg"]!=null){
                    versionmsg = map["iosversionmsg"] as String
                }
                if(map["iosversionurl"]!=null){
                    versionurl = map["iosversionurl"] as String
                }
            }

        }

        var name = person.name
        val page = userService.findPersondtlByUserid(user.userid!!, no)
        return JsonResult.ok("OK").put("page", page)
                ?.put("today", today)
                ?.put("yesterday", yester)
                ?.put("point", pi)
                ?.put("amount", amount)
                ?.put("paypwdset", payseted)
                ?.put("name", name)
                ?.put("needrebind", needrebind)
                ?.put("signed", signed)
                ?.put("version",version)
                ?.put("minversion",minversion)
                ?.put("versionmsg",versionmsg)
                ?.put("versionurl",versionurl)
                ?.put("userid", if (user.userid.isNullOrEmpty()) "" else user.userid)!!.put("t", t)!!
    }

    /**
     * 账单明细
     * */
    @RequestMapping("/billdetail")
    fun billdetail(billid: String): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user: TBMobileUser? = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (user!!.userid.isNullOrEmpty()) {
            return JsonResult.ok("OK")
        }
        val dtl = userService.findPersondtlDetailByUserid(user.userid!!, billid)
        return JsonResult.ok("OK").put("dtl", dtl)!!
    }

    /**
     * 密码修改
     * */
    @RequestMapping("/pwdset")
    fun pwdset(oldpwd: String, newpwd: String, renewpwd: String): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (newpwd != renewpwd) {
            return JsonResult.error("两次密码不一致，请确认")
        }
        if (!newpwd.matches(Regex("^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,32}$"))) {
            return JsonResult.error("密码必须包含数字和字符，长度6~32位")
        }
        if (newpwd.isEmpty() || newpwd.length < 6) {
            return JsonResult.error("请重新设置密码，密码不能小于6位字符")
        }
        val pwdtimes = user.checkLoginpwdtime()
        if (pwdtimes == -1) {
            if (!user.jti.isNullOrEmpty()) {
                apiJwtRepository.deleteById(user.jti!!)
            }
            return JsonResult.error(-1, "原密码错误次数过多，将退出系统，请重新登录系统或点击忘记密码功能找回密码")
        } else if (pwdtimes == 1) {
            mobileApiService.saveUser(user)
        }
        val encoder = BCryptPasswordEncoder()
        if (!encoder.matches(oldpwd, user.loginpwd)) {
            user.updateLoginpwderror(false).also {
                if (it) mobileApiService.saveUser(user)
            }
            return JsonResult.error("原密码错误")
        } else {
            user.updateLoginpwderror(true)
        }
        user.loginpwd = encoder.encode(newpwd)
        mobileApiService.saveUser(user)
        return JsonResult.ok("密码修改成功")
    }

    /**
     *
     * 市民卡挂失
     * */
    @RequestMapping("/cardinfor")
    fun cardinfor(): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if (user.userid.isNullOrEmpty()) {
            return JsonResult.error(-1, "银行卡未绑定，请先绑定")
        }
        val person = userService.findOnePersonByUserid(user.userid!!)
        val card = mobileApiService.findCardByUserid(user.userid!!)
                ?: return JsonResult.error(-1, "银行卡未绑定，请先绑定")
        var status = ""
        //normal/loss/frozen/locked
        when (card.transStatus) {
            TradeDict.STATUS_NORMAL -> status = "正常"
            TradeDict.STATUS_LOST -> status = "已挂失"
            TradeDict.STATUS_LOCKED -> status = "已锁定"
            TradeDict.STATUS_FROZEN -> status = "已冻结"
        }
        return JsonResult.ok("ok").put("name", person.name)
                ?.put("cardno", card.cardno)
                ?.put("cardstatus", status)!!
    }

    /**
     *
     * 市民卡挂失
     * */
    @RequestMapping("/cardlost")
    fun cardlost(paypwd: String): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        val paypwdtimes = user.checkPaypwdtime()
        if (paypwdtimes == -1) {
            return JsonResult.error("支付密码错误次数过多，请30分钟后再试")
        } else if (paypwdtimes == 1) {
            mobileApiService.saveUser(user)
        }
        val encoder = BCryptPasswordEncoder()
        if (!encoder.matches(paypwd, user.paypwd)) {
            user.updatePaypwderror(false).also {
                if (it) mobileApiService.saveUser(user)
            }
            return JsonResult.error("支付密码错误")
        } else {
            user.updatePaypwderror(true).also {
                if (it) mobileApiService.saveUser(user)
            }
        }
        var card = mobileApiService.findCardByUserid(user.userid!!)
                ?: return JsonResult.error(-1, "银行卡未绑定，请先绑定")
        if (card.transStatus != TradeDict.STATUS_NORMAL) {
            return JsonResult.error("卡状态非正常，不能挂失")
        }
        card.transStatus = TradeDict.STATUS_LOST
        mobileApiService.saveCard(card)
        return JsonResult.ok("ok")
    }

    /**
     *
     * 二维码在线生成
     * */
    @RequestMapping("/qrcode")
    fun qrcode(): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        val resp = qrcodeService.encodeCode(user.uid)
        return if(resp.retcode==0){
            JsonResult.ok("ok").put("qrcode", resp.retmsg)!!
        }else{
            JsonResult.error(resp.retmsg)
        }
    }

    /**
     *
     * 解除银行协议
     * */
    @RequestMapping("/unsignbxy")
    fun unSignbxy(): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        var signed: String
        if (!user.userid.isNullOrEmpty()) {
            var card = mobileApiService.findCardByUserid(user.userid!!)
                    ?: return JsonResult.error("银行卡不存在，不能解除代扣协议")
            //call sign api
            val person = userService.findOnePersonByUserid(card.userid)
            val captcha = ""//此处为验证码，暂由此参数代替
            var resp = citizencardPayService.signCard(card.cardno, person.name, person.idtype, person.idno, user.phone!!, YnrccUtil.TRANSTYPE_UNSIGNCARD,captcha)
            if (resp.code != "0000") {
                return JsonResult.error(resp.message)
            }
            card.signed = false
            mobileApiService.saveCard(card)
            signed = TradeDict.STATUS_NO
        } else {
            return JsonResult.error("未绑定银行卡，不能解除代扣协议")
        }
        return JsonResult.ok("ok")
                .put("signed", signed)!!
    }

    /**
     * 解除绑定
     * */
    @RequestMapping("/unbindcard")
    fun unbindcard(paypwd: String): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        if(user.paypwd.isNullOrEmpty()){
            return JsonResult.error("支付密码未设置，请先设置")
        }
        val paypwdtimes = user.checkPaypwdtime()
        if (paypwdtimes == -1) {
            return JsonResult.error("支付密码错误次数过多，请30分钟后再试")
        } else if (paypwdtimes == 1) {
            mobileApiService.saveUser(user)
        }
        val encoder = BCryptPasswordEncoder()
        if (!encoder.matches(paypwd, user.paypwd)) {
            user.updatePaypwderror(false).also {
                if (it) mobileApiService.saveUser(user)
            }
            return JsonResult.error("支付密码错误")
        } else {
            user.updatePaypwderror(true).also {
                if (it) mobileApiService.saveUser(user)
            }
        }
        var card = mobileApiService.findCardByUserid(user.userid!!)
                ?: return JsonResult.error(-1, "银行卡未绑定，无需解绑")
        card.signed = false
        user.userid = null
        mobileApiService.saveCard(card)
        mobileApiService.saveUser(user)
        return JsonResult.ok("OK")
                ?.put("signed", TradeDict.STATUS_NO)!!
    }

    /**
     * 上传头像
     * */
    @RequestMapping("/uploadphoto")
    fun uploadPhoto(file: MultipartFile): JsonResult {
        val p = SecurityContextHolder.getContext().authentication
        val user = mobileApiService.findUserById(p.name)
                ?: return JsonResult.error("用户不存在，请注册")
        /**
         * TODO
         * 1.已有头像更新
         * 2.没有头像上传
         * 3.返回图片ID
         *
        */
        return JsonResult.ok("OK")
    }
}