package com.supwisdom.dlpay.mobile.domain

import com.supwisdom.dlpay.api.util.DateUtil
import com.supwisdom.dlpay.framework.util.TradeDict
import org.hibernate.annotations.GenericGenerator
import org.springframework.security.core.GrantedAuthority
import org.springframework.security.core.userdetails.UserDetails
import javax.persistence.*
import javax.validation.constraints.NotNull

@Entity
@Table(name = "TB_MOBILE_USER",indexes = [Index(name = "mobile_user_loginid_idx", columnList = "loginid", unique = true)])
class TBMobileUser : UserDetails {
    override fun getAuthorities(): Collection<GrantedAuthority>? {
        return this.auths
    }

    override fun isEnabled(): Boolean {
        return TradeDict.STATUS_CLOSED != this.status
    }

    override fun getUsername(): String {
        return this.loginid
    }

    override fun isCredentialsNonExpired(): Boolean {
        return true
    }

    override fun getPassword(): String {
        return this.loginpwd
    }

    override fun isAccountNonExpired(): Boolean {
        if(expiredate.isNullOrEmpty()){
            return true
        }
        return this.expiredate!! >= DateUtil.getNow("yyyyMMdd")
    }

    override fun isAccountNonLocked(): Boolean {
        return TradeDict.STATUS_LOCKED != this.status
    }

    @Transient
    var auths: Collection<GrantedAuthority>? = null

    @Id
    @GenericGenerator(name = "idGenerator", strategy = "uuid")
    @GeneratedValue(generator = "idGenerator")
    @Column(name = "uid", nullable = false, length = 32)
    var uid: String = ""
    /**
     * 登录id
     * */

    @Column(name = "loginid", length = 64)
    @NotNull
    var loginid: String = ""

    /**
     * 登录密码
     * */
    @Column(name = "loginpwd", length = 64)
    var loginpwd: String = ""

    /**
     * 设备uuid
     * */
    @Column(name = "devuid", length = 64)
    var devuid: String? = null

    /**
     * 注册时间
     * */
    @Column(name = "registerdate", length = 16)
    var registerdate: String? = null

    /**
     * 关联tb_person
     * */
    @Column(name = "userid", length = 32)
    var userid: String? = null

    /**
     * 银行卡绑定时间
     * */
    @Column(name = "bindtime", length = 14)
    var bindtime: String? = null

    /**
     * 注册手机类型
     * */
    @Column(name = "registerplatform", length = 100)
    var registerplatform: String? = null

    /**
     * 最后登录时间
     * */
    @Column(name = "lastlogin", length = 16)
    var lastlogin: String? = null

    /**
     * 最后登录手机类型
     * */
    @Column(name = "lastloginplatform", length = 100)
    var lastloginplatform: String? = null

    /**
     * 状态
     * */
    @Column(name = "status", length = 16)
    var status: String? = null

    /**
     * 支付密码
     * */
    @Column(name = "paypwd", length = 64)
    var paypwd: String? = null

    /**
     * 登录密码错误次数
     * */
    @Column(name = "loginpwderror", length = 4)
    var loginpwderror: Int = 0

    /**
     * 登录密码错误时间
     * */
    @Column(name = "loginpwderrortime", length = 16)
    var loginpwderrortime: Long? = 0

    /**
     * 支付密码错误次数
     * */
    @Column(name = "paypwderror", length = 4)
    var paypwderror: Int = 0

    /**
     * 支付密码错误时间
     * */
    @Column(name = "paypwderrortime", length = 16)
    var paypwderrortime: Long? = 0

    /**
     * jti
     * */
    @Column(name = "jti", length = 64)
    var jti: String? = null

    /**
     * 签约时间
     * */
    @Column(name = "signedtime", length = 20)
    var signedtime: String? = null

    /**
     * 头像
     * */
    @Column(name = "ulogo", length = 100)
    var ulogo: String? = null
    @Column(name = "rsaprivate", length = 1000)
    var rsaprivate: String? = null
    @Column(name = "rsapublic", length = 1000)
    var rsapublic: String? = null
    @Column(name = "secertkey", length = 64)
    var secertkey: String? = null

    @Column(name = "tenantid", length = 32)
    var tenantid:String? = null

    @Column(name = "expiredate", length = 8)
    var expiredate: String? = null

    @Column(name = "email", length = 100)
    var email: String? = null

    @Column(name = "phone", length = 15)
    var phone: String? = null

    fun checkLoginpwdtime():Int{
        if (this.loginpwderror >= 5 && (System.currentTimeMillis() - this.loginpwderrortime!!) < 1000 * 60 * 30) {
            return -1
        } else if (this.loginpwderror >= 5 && (System.currentTimeMillis() - this.loginpwderrortime!!) > 1000 * 60 * 30) {
            //更新时间
            this.loginpwderror = 0
            this.loginpwderrortime = null
            return 1
        }
        return 0
    }

    fun updateLoginpwderror(ok: Boolean): Boolean {
        return if (ok) {
            if (this.loginpwderror > 0) {
                this.loginpwderror = 0
                this.loginpwderrortime = null
                true
            } else {
                false
            }
        } else {
            if (this.loginpwderror == 0) {
                this.loginpwderrortime = System.currentTimeMillis()
            }
            this.loginpwderror += 1
            true
        }
    }

    fun checkPaypwdtime():Int{
        if (this.paypwderror >= 5 && (System.currentTimeMillis() - this.paypwderrortime!!) < 1000 * 60 * 30) {
            return -1
        } else if (this.paypwderror >= 5 && (System.currentTimeMillis() - this.paypwderrortime!!) > 1000 * 60 * 30) {
            //更新时间
            this.paypwderror = 0
            this.paypwderrortime = null
            return 1
        }
        return 0
    }

    fun updatePaypwderror(ok: Boolean): Boolean {
        return if (ok) {
            if (this.paypwderror > 0) {
                this.paypwderror = 0
                this.paypwderrortime = null
                true
            } else {
                false
            }
        } else {
            if (this.paypwderror == 0) {
                this.paypwderrortime = System.currentTimeMillis()
            }
            this.paypwderror += 1
            true
        }
    }
}