package com.supwisdom.dlpay.mobile.service.impl

import com.mascloud.sdkclient.Client
import com.supwisdom.dlpay.api.bean.BaseResp
import com.supwisdom.dlpay.api.dao.CardDao
import com.supwisdom.dlpay.api.domain.TCard
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.mobile.dao.MobileUserDao
import com.supwisdom.dlpay.mobile.dao.PagesDao
import com.supwisdom.dlpay.mobile.domain.TBMobileUser
import com.supwisdom.dlpay.mobile.domain.TBPages
import com.supwisdom.dlpay.mobile.service.MobileApiService
import com.supwisdom.dlpay.util.ConstantUtil
import mu.KotlinLogging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import java.util.*

@Service
class MobileApiServiceImpl : MobileApiService {
    @Autowired
    lateinit var mobileUserDao: MobileUserDao

    @Autowired
    lateinit var cardDao: CardDao

    @Autowired
    lateinit var pagesDao: PagesDao

    @Autowired
    lateinit var systemUtilService: SystemUtilService
    companion object {
        var isMsgLogined: Boolean = false
    }
    val logger = KotlinLogging.logger { }

    override fun saveUser(user: TBMobileUser): TBMobileUser {
        return mobileUserDao.save(user)
    }

    override fun findPageById(pageid: String): TBPages? {
        return pagesDao.findById(pageid).let {
            if (it.isPresent) it.get() else null
        }
    }

    override fun findUserByPhone(phone: String): TBMobileUser? {
        return mobileUserDao.findByPhone(phone)
    }

    override fun findUserById(id: String): TBMobileUser? {
        return mobileUserDao.findById(id).let {
            if (it.isPresent) it.get() else null
        }
    }

    override fun findCardByNo(cardno: String): TCard? {
        return cardDao.findCardByCardnoAndCardtype(cardno, ConstantUtil.CARDTYPE_BANKCARD)
    }

    override fun findCardByUserid(userid: String): TCard? {
        return cardDao.findCardByUseridAndCardtype(userid, ConstantUtil.CARDTYPE_BANKCARD)
    }

    override fun findCityCardByUserid(userid: String): TCard? {
        return cardDao.findCardByUseridAndCardtype(userid, ConstantUtil.CARDTYPE_CITIZENCARD)
    }

    override fun saveCard(card: TCard): TCard {
        return cardDao.save(card)
    }

    override fun sendSms(phone: String, code: String): BaseResp {
        var resp = BaseResp()
        var url = systemUtilService.getBusinessValue("sms.url")
        if (url.isNullOrEmpty()) {
            resp.retcode = "1"
            resp.retmsg = "短信业务参数未配置"
            logger.error { "短信参数：sms.url 未在业务表中配置" }
            return resp
        }
        var account = systemUtilService.getBusinessValue("sms.account")
        if (account.isNullOrEmpty()) {
            resp.retcode = "1"
            resp.retmsg = "短信业务参数未配置"
            logger.error { "短信参数：sms.account 未在业务表中配置" }
            return resp
        }
        var pwd = systemUtilService.getBusinessValue("sms.pwd")
        if (pwd.isNullOrEmpty()) {
            resp.retcode = "1"
            resp.retmsg = "短信业务参数未配置"
            logger.error { "短信参数：sms.pwd 未在业务表中配置" }
            return resp
        }
        var ecname = systemUtilService.getBusinessValue("sms.ecname")
        if (ecname.isNullOrEmpty()) {
            resp.retcode = "1"
            resp.retmsg = "短信业务参数未配置"
            logger.error { "短信参数：sms.ecname 未在业务表中配置" }
            return resp
        }
        var addserial = systemUtilService.getBusinessValue("sms.addserial")
        if (addserial.isNullOrEmpty()) {
            addserial=""
        }
        var sign = systemUtilService.getBusinessValue("sms.sign")
        if (sign.isNullOrEmpty()) {
            resp.retcode = "1"
            resp.retmsg = "短信业务参数未配置"
            logger.error { "短信参数：sms.sign 未在业务表中配置" }
            return resp
        }
        var tempid = systemUtilService.getBusinessValue("sms.tempid")
        if (tempid.isNullOrEmpty()) {
            resp.retcode = "1"
            resp.retmsg = "短信业务参数未配置"
            logger.error { "短信参数：sms.tempid 未在业务表中配置" }
            return resp
        }
        var priority = systemUtilService.getBusinessValue("sms.priority")
        if (priority.isNullOrEmpty()) {
            priority = "1"
        }
        var client = Client.getInstance()
        // 正式环境IP，登录验证URL，用户名，密码，集团客户名称
        if(!isMsgLogined){
            var ret = client.login(url, account, pwd, ecname)
            if (!ret) {
                logger.error { "无法登陆短信平台，身份验证失" }
                resp.retcode = "1"
                resp.retmsg = "无法登陆短信平台"
                return resp
            }
            isMsgLogined = true
        }
        var sendResult = client.sendTSMS(arrayOf(phone),
                tempid, arrayOf(code), addserial, priority.toInt(), sign, UUID.randomUUID().toString())
        println("推送结果: $sendResult")
        return if (sendResult == 1 || sendResult == 110) {
            resp.retcode = "0"
            resp.retmsg = "成功"
            resp
        } else if (sendResult == 104) {
            resp.retcode = "1"
            resp.retmsg = "手机号错误"
            resp
        } else if (sendResult == 105) {
            //105 需要重新登录
            var ret = client.login(url, account, pwd, ecname)
            if (!ret) {
                logger.error { "无法登陆短信平台，身份验证失" }
                resp.retcode = "1"
                resp.retmsg = "无法登陆短信平台"
                return resp
            }
            resp.retcode = "1"
            resp.retmsg = "短信发送失败，请稍后再试"
            resp
        } else if (sendResult == 106 || sendResult == 108 || sendResult == 111) {
            logger.error { "106：网关签名为空， 用户需要填写网关签名编号；108：JMS异常，用户侧网络问题。需要检查防火墙配置和网络连通性，看是否能够与云MAS平台正常连接；111：扩展码错误,扩展码只能是15位以内数字或空字符串" }
            resp.retcode = "1"
            resp.retmsg = "短信发送失败，请稍后再试"
            resp
        } else {
            resp.retcode = "1"
            resp.retmsg = "短信发送失败，请稍后再试"
            resp
        }
    }

    override fun findByUseridAndStatus(userid: String, status: String): List<TBMobileUser>? {
        return mobileUserDao.findByUseridAndStatus(userid, status)
    }

    override fun findCardByUseridAndCardphyid(userid: String, cardtype: String, cardphyid: String?): TCard? {
        return if (cardphyid.isNullOrEmpty()) {
            cardDao.findCardByUseridAndCardtype(userid, cardtype)
        } else {
            cardDao.findBankcardByCitizencard(userid, cardtype, cardphyid)
        }
    }
}