package com.supwisdom.dlpay.mobile.service.impl

import com.supwisdom.dlpay.mobile.dao.MobileUserDao
import com.supwisdom.dlpay.mobile.domain.TBMobileUser
import com.supwisdom.dlpay.mobile.exception.UserLoginFailException
import com.supwisdom.dlpay.mobile.service.MobileUserService
import mu.KotlinLogging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.security.core.GrantedAuthority
import org.springframework.security.core.authority.AuthorityUtils
import org.springframework.security.core.userdetails.UserDetails
import org.springframework.security.core.userdetails.UsernameNotFoundException
import org.springframework.stereotype.Service

@Service
class MobileUserServiceImpl : MobileUserService {
    companion object {
        const val TIME_INTERVAL = 1000 * 60 * 30
    }
    val logger = KotlinLogging.logger { }
    @Autowired
    lateinit var mobileUserDao: MobileUserDao

    override fun loadUserByUsername(username: String?): UserDetails {
        logger.error("username:$username")
        if (username.isNullOrEmpty()) {
            throw UsernameNotFoundException("用户不存在")
        }
        val temp = mobileUserDao.findByLoginid(username)
        if (temp != null) {
            if (temp.loginpwd.isEmpty()) {
                throw UserLoginFailException("用户注册后未设置登录密码，请找回密码或重新注册")
            }
            if (temp.loginpwderror >= 5 && (System.currentTimeMillis() - temp.loginpwderrortime!!) < TIME_INTERVAL) {
                throw UserLoginFailException("密码错误次数过多，请30分钟后再试")
            } else if (temp.loginpwderror >= 5 && (System.currentTimeMillis() - temp.loginpwderrortime!!) > TIME_INTERVAL) {
                //更新时间
                temp.loginpwderror = 0
                temp.loginpwderrortime = null
                mobileUserDao.save(temp)
            }
            val authorities: Collection<GrantedAuthority> = AuthorityUtils.createAuthorityList("ROLE_USER")
            temp.auths = authorities
        } else {
            throw UsernameNotFoundException("用户不存在")
        }
        return temp
    }

    override fun getByUid(uid: String): TBMobileUser? {
        return mobileUserDao.findById(uid).let {
            if (it.isPresent) it.get() else null
        }
    }
}