package com.supwisdom.dlpay.portal.dao

import com.supwisdom.dlpay.portal.domain.TBResource
import org.springframework.data.jpa.repository.JpaRepository
import org.springframework.data.jpa.repository.Query
import org.springframework.stereotype.Repository

@Repository
interface ResourceDao : JpaRepository<TBResource, String> {

    @Query("select t2 from TRoleResource t1,TBResource t2 where t1.resid = t2.resid and t2.isleaf = '0' and t1.roleid=?1 order by t2.ordernum")
    fun findRootListByRole(roleId: String): List<TBResource>

    @Query("select t2 from TRoleResource t1,TBResource t2 where t1.resid = t2.resid and t2.isleaf = '1' and t1.roleid=?1 and t2.parentid=?2 order by t2.ordernum")
    fun findChildrenByRoleAndParent(roleId: String, parentId: String): List<TBResource>
}