package com.supwisdom.dlpay.portal.service

import com.supwisdom.dlpay.framework.jpa.page.Pagination
import com.supwisdom.dlpay.portal.bean.ArticleSearchBean
import com.supwisdom.dlpay.portal.domain.TBArticle
import org.springframework.transaction.annotation.Transactional
import org.springframework.web.multipart.MultipartHttpServletRequest

interface ArticleService {
    @Transactional
    fun uploadPic(request: MultipartHttpServletRequest): Map<String, String>
    @Transactional
    fun saveArticle(article: TBArticle)
    @Transactional
    fun releaseArticle(article: TBArticle)
    @Transactional
    fun reviewArticle(article: TBArticle,opername:String)
    @Transactional
    fun getArticleList(bean:ArticleSearchBean): Pagination
    @Transactional
    fun deleteArticle(articleno:String)
    @Transactional
    fun switchDisplay(articleno:String,value:String):String
    @Transactional
    fun getArticle(articleno:String):TBArticle
}