package com.supwisdom.dlpay.portal.service.Impl

import com.supwisdom.dlpay.framework.dao.BusinessparaDao
import com.supwisdom.dlpay.framework.jpa.page.Pagination
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.portal.bean.ArticleSearchBean
import com.supwisdom.dlpay.portal.dao.ArticleAuthDao
import com.supwisdom.dlpay.portal.dao.ArticleDao
import com.supwisdom.dlpay.portal.dao.ColumnDao
import com.supwisdom.dlpay.portal.domain.TBArticle
import com.supwisdom.dlpay.portal.domain.TBArticleAuth
import com.supwisdom.dlpay.portal.service.ArticleService
import com.supwisdom.dlpay.portal.util.PortalConstant
import com.supwisdom.dlpay.portal.util.PutImageToServer
import mu.KotlinLogging
import net.coobird.thumbnailator.Thumbnails
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import org.springframework.web.multipart.MultipartFile
import org.springframework.web.multipart.MultipartHttpServletRequest
import java.io.File
import java.io.FileInputStream
import java.io.IOException
import java.sql.Timestamp
import java.util.*
import kotlin.math.sqrt

@Service
class ArticleServiceImpl : ArticleService {
    @Autowired
    lateinit var systemUtilService: SystemUtilService
    @Autowired
    lateinit var articleDao: ArticleDao
    @Autowired
    lateinit var businessparaDao: BusinessparaDao
    @Autowired
    lateinit var articleAuthDao: ArticleAuthDao
    @Autowired
    lateinit var columnDao: ColumnDao

    val logger = KotlinLogging.logger { }

    override fun saveArticle(article: TBArticle) {
        if (article.status != null && article.status != PortalConstant.ARTICLE_STATUS_SAVE) {
            throw RuntimeException("文章状态异常")
        }
        val timestamp = systemUtilService.sysdatetime.sysdate
        article.status = PortalConstant.ARTICLE_STATUS_SAVE
        saveArticle(article,timestamp)
    }

    fun saveArticle(article: TBArticle,timestamp:Timestamp): TBArticle {
        if (StringUtil.isEmpty(article.articleid)) {
            val currentNoBusiness = businessparaDao.findByParakey(PortalConstant.SYSPARA_ARTICLE_CURRENTNO)
                    ?: throw RuntimeException("文章编号参数未配置")
            val currentNo = currentNoBusiness.paraval.toInt()
            currentNoBusiness.paraval = (currentNo + 1).toString()
            businessparaDao.save(currentNoBusiness)
            article.createtime = timestamp
            article.articleno = String.format("%08d", currentNo)
            article.hits = 0
            article.isdisplay = PortalConstant.YES
            article.isdelete = PortalConstant.NO
        } else {
            article.updatetime = timestamp
        }
        return articleDao.save(article)
    }

    override fun releaseArticle(article: TBArticle) {
        if (article.status != null &&
                article.status != PortalConstant.ARTICLE_STATUS_SAVE &&
                article.status != PortalConstant.ARTICLE_STATUS_PASS) {
            throw RuntimeException("文章状态异常")
        }
        val timestamp = systemUtilService.sysdatetime.sysdate
        article.releasetime = timestamp
        article.status = PortalConstant.ARTICLE_STATUS_RELEASED
        val savedArticle = saveArticle(article,timestamp)
        val optional = columnDao.findById(savedArticle.columnid)
        if (!optional.isPresent) {
            throw RuntimeException("文章栏目未找到")
        }
        val column = optional.get()
        if (column.needreview == PortalConstant.YES) {
            articleAuthDao.findByArticlenoAndStatus(savedArticle.articleno,
                    PortalConstant.ARTICLE_STATUS_PASS)
                    ?: throw RuntimeException("文章未通过审核，不能发布")
        }
    }


    override fun reviewArticle(article: TBArticle, opername: String) {
        if (article.status != null && article.status != PortalConstant.ARTICLE_STATUS_SAVE) {
            throw RuntimeException("文章状态异常")
        }
        val timestamp = systemUtilService.sysdatetime.sysdate
        article.status = PortalConstant.ARTICLE_STATUS_REVIEW
        val savedArticle = saveArticle(article,timestamp)
        val optional = columnDao.findById(savedArticle.columnid)
        if (!optional.isPresent) {
            throw RuntimeException("文章栏目未找到")
        }
        val column = optional.get()
        val articleAuth = TBArticleAuth().apply {
            this.articleno = savedArticle.articleno
            this.status = PortalConstant.ARTICLE_STATUS_REVIEW
            this.articleopername = opername
            this.articletitle = savedArticle.title
            this.columnname = column.name
            this.submitdate = systemUtilService.sysdatetime.hostdatetime
        }
        articleAuthDao.save(articleAuth)
    }

    override fun getArticleList(bean: ArticleSearchBean): Pagination {
        return articleDao.getArticleList(bean)
    }

    override fun deleteArticle(articleno: String) {
        val article = articleDao.findByArticlenoAndIsdelete(articleno, PortalConstant.NO)
                ?: throw RuntimeException("编号为：[${articleno}]的文章未找到")
        article.isdelete = PortalConstant.YES
        articleDao.save(article)
    }

    override fun switchDisplay(articleno: String, value: String): String {
        val article = articleDao.findByArticlenoAndIsdelete(articleno, PortalConstant.NO)
                ?: throw RuntimeException("编号为：[${articleno}]的文章未找到")
        article.isdisplay = value
        articleDao.save(article)
        return article.isdisplay
    }

    override fun getArticle(articleno: String): TBArticle {
        return articleDao.findByArticlenoAndIsdelete(articleno, PortalConstant.NO)
                ?: throw RuntimeException("编号为：[${articleno}]的文章未找到")
    }

    override fun uploadPic(request: MultipartHttpServletRequest): Map<String, String> {
        val map: MutableMap<String, String> = HashMap()
        try {
            logger.error("===put up pic")
            val pathDir = "/files/"
            /** 得到图片保存目录的真实路径  */
            val logoRealPathDir = request.session.servletContext
                    .getRealPath(pathDir)
            /** 根据真实路径创建目录  */
            val logoSaveFile = File(logoRealPathDir)
            if (!logoSaveFile.exists()) logoSaveFile.mkdirs()
            /** 页面控件的文件流  */
            val multipartFile: MultipartFile
            multipartFile = request.getFile("file")
            //System.out.println(multipartFile);
            /* 获取文件的后缀 */
            val suffix = multipartFile.originalFilename.substring(
                    multipartFile.originalFilename.lastIndexOf("."))
            //* 拼成完整的文件保存路径加文件 *//*
            val name = System.currentTimeMillis().toString() + suffix
            val fileName = logoRealPathDir + File.separator + name
            val file = File(fileName)
            // String data = file.getPath();
            try {
                multipartFile.transferTo(file)
            } catch (e: IllegalStateException) {
                logger.error("error:", e)
            } catch (e: IOException) {
                logger.error("error:", e)
            }
            //savePicToDb(fileName, goodsidString);*/
            //String filepath = logoRealPathDir + File.separator + multipartFile.getOriginalFilename();
            val size = multipartFile.size
            var maxSize = 200 * 1024.toLong()
            val imageMaxConf = systemUtilService.getBusinessValue(PortalConstant.SYSPARA_IMAGE_MAXSIZE)
            if (imageMaxConf != null && !StringUtil.isEmpty(imageMaxConf)) {
                try {
                    maxSize = imageMaxConf.toLong()
                } catch (e: Exception) {
                }
            }
            var minwidth = 150
            var minheight = 150
            val imageMinConf = systemUtilService.getBusinessValue(PortalConstant.SYSPARA_IMAGE_MINISIZE)
            if (imageMinConf != null && !StringUtil.isEmpty(imageMinConf)) {
                try {
                    val temps = imageMinConf.split(",")
                    if (temps.size == 2) {
                        minwidth = temps[0].toInt()
                        minheight = temps[1].toInt()
                    }
                } catch (e: Exception) {
                    logger.error("error:", e)
                }
            }
            logger.error("===put up pic 1")
            var baseURL = systemUtilService.getBusinessValue(PortalConstant.SYSPARA_IMAGE_URLASSIGN)
            if (baseURL == null || StringUtil.isEmpty(baseURL)) {
                map["retmsg"] = "系统未配置图片服务器地址，无法保存图片！"
                map["retcode"] = "1"
                return map
            }
            if (!baseURL.startsWith("http")) {
                baseURL = "http://$baseURL"
            }
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length - 1)
            }
            logger.error("===put up pic 2")
            var minImageURL: String
            val picid: String
            val minpicid: String
            var imageURL = systemUtilService.getBusinessValue(PortalConstant.SYSPARA_IMAGE_URLPUSH)
            if (imageURL == null || StringUtil.isEmpty(imageURL)) {
                map["retmsg"] = "系统未配置图片服务器地址，无法保存图片！"
                map["retcode"] = "1"
                return map
            }
            logger.error("===put up pic 4")
            if (!imageURL.startsWith("http")) {
                imageURL = "http://$imageURL"
            }
            if (!imageURL.endsWith("/")) {
                imageURL += "/"
            }
            minImageURL = imageURL
            if (!minImageURL.startsWith("http")) {
                minImageURL = "http://$minImageURL"
            }
            if (!minImageURL.endsWith("/")) {
                minImageURL += "/"
            }
            val assign = "$baseURL/dir/assign?count=2"
            val bean = PutImageToServer.postBefore(assign)
            if (bean == null || StringUtil.isEmpty(bean.getFid())) {
                map["retmsg"] = "图片上传失败，无法连接图片服务器！"
                map["retcode"] = "1"
                return map
            }
            imageURL += bean.fid
            picid = bean.fid
            val minImgBean = PutImageToServer.postBefore(assign)
            if (minImgBean == null || StringUtil.isEmpty(minImgBean.getFid())) {
                map["retmsg"] = "图片上传失败，无法连接图片服务器！"
                map["retcode"] = "1"
                return map
            }
            minpicid = minImgBean.fid
            minImageURL += minImgBean.fid
            //}
            val processToFile = logoRealPathDir + File.separator + picid + ".jpg"
            var scale = 1.0
            if (size > 0 && size > maxSize) {
                scale = maxSize * 1.0 / size
            }
            try {
                if (scale < 0.7) {
                    val s = sqrt(maxSize.toDouble()).toInt()
                    Thumbnails.of(fileName).size(s, s).outputFormat("jpg").toFile(processToFile)
                } else {
                    Thumbnails.of(fileName).scale(1.0).outputQuality(scale).outputFormat("jpg").toFile(processToFile)
                }
                logger.error("===put up pic 5")
            } catch (e: Exception) {
                map["retmsg"] = "图片上传失败，压缩失败"
                map["retcode"] = "1"
                file.delete()
                return map
            }
            val file1 = File(processToFile)
            val processToMinFile = logoRealPathDir + File.separator + minpicid + ".jpg"
            try {
                Thumbnails.of(fileName).size(minwidth, minheight).outputFormat("jpg").toFile(processToMinFile)
            } catch (e: Exception) {
                map["retmsg"] = "图片上传失败，压缩失败"
                map["retcode"] = "1"
                file.delete()
                file1.delete()
                return map
            }
            val file2 = File(processToMinFile)
            logger.error("==========imageurl=$imageURL")
            if (!PutImageToServer.postImage(imageURL, FileInputStream(file1))) {
                map["retmsg"] = "图片上传失败，请稍后再试"
                map["retcode"] = "1"
                file1.delete()
                file2.delete()
                file.delete()
                logger.error("=step1 fail=")
                return map
            }
            if (!PutImageToServer.postImage(minImageURL, FileInputStream(file2))) {
                map["retmsg"] = "图片上传失败，请稍后再试"
                map["retcode"] = "1"
                file1.delete()
                file2.delete()
                file.delete()
                logger.error("=step2 fail=")
            } else {
                map["retmsg"] = "上传成功"
                map["retcode"] = "0"
                file1.delete()
                file2.delete()
                file.delete()
                map["picid"] = picid
                map["minpicid"] = minpicid
                logger.error("=step3 success=")
            }
        } catch (e: Exception) {
            map["retmsg"] = "图片上传失败--" + e.message
            map["retcode"] = "1"
            // return map;
            logger.error("=step fail=", e)
        }
        return map
    }
}