package com.supwisdom.dlpay.portal.service.Impl

import com.supwisdom.dlpay.framework.jpa.page.Pagination
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.portal.bean.ColumnSearchBean
import com.supwisdom.dlpay.portal.dao.ColumnDao
import com.supwisdom.dlpay.portal.domain.TBColumn
import com.supwisdom.dlpay.portal.service.ColumnService
import com.supwisdom.dlpay.portal.util.PortalConstant
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class ColumnServiceImpl : ColumnService {
    @Autowired
    lateinit var columnDao: ColumnDao

    override fun getColumnList(bean: ColumnSearchBean): Pagination {
        return columnDao.getColumnList(bean)
    }

    override fun getAllColumnList(): List<TBColumn>? {
        return columnDao.findAll()
    }

    override fun saveColumn(column: TBColumn):String? {
        var columnid = "####"
        if (!StringUtil.isEmpty(column.columnid)) {
            columnid = column.columnid
        }else{
            if (StringUtil.isEmpty(column.parentid)) {
                column.isleaf = PortalConstant.NO
            } else {
                column.isleaf = PortalConstant.YES
            }
        }
        val nameColumn = columnDao.findByNameAndColumnidNot(column.name,columnid)
        if (nameColumn!=null){
            return "栏目名称已存在，请更换！"
        }
        val codeColumn = columnDao.findByCodeAndColumnidNot(column.code,columnid)
        if (codeColumn!=null){
            return "栏目CODE已存在，请更换！"
        }
        columnDao.save(column)
        return null
    }
}