package com.supwisdom.dlpay.portal.service.Impl

import com.supwisdom.dlpay.framework.jpa.page.Pagination
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.portal.bean.FeedbackSearchBean
import com.supwisdom.dlpay.portal.dao.AnnexDao
import com.supwisdom.dlpay.portal.dao.FeedbackDao
import com.supwisdom.dlpay.portal.dao.ReplyDao
import com.supwisdom.dlpay.portal.domain.TBFeedback
import com.supwisdom.dlpay.portal.domain.TBReply
import com.supwisdom.dlpay.portal.service.FeedbackService
import com.supwisdom.dlpay.portal.util.PortalConstant
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class FeedbackServiceImpl : FeedbackService {
    @Autowired
    lateinit var feedbackDao: FeedbackDao
    @Autowired
    lateinit var replyDao: ReplyDao
    @Autowired
    lateinit var systemUtilService: SystemUtilService
    @Autowired
    lateinit var annexDao: AnnexDao

    override fun getFeedbackList(bean: FeedbackSearchBean): Pagination {
        val page = feedbackDao.getFeedbackList(bean)
        val list = page.list as List<TBFeedback>
        list.forEach { feedback ->
            run {
                feedback.pictures = annexDao.getByFbid(feedback.fbid)
            }
         }
        return page
    }

    override fun getReplyListByFbId(fbId: String): List<TBReply> {
        return replyDao.getAllByFbid(fbId)
    }

    override fun saveReplyListByFbId(reply: TBReply): String? {
        val optional = feedbackDao.findById(reply.fbid)
        return if (optional.isPresent) {
            val feedback = optional.get()
            reply.updatetime = systemUtilService.sysdatetime.hostdatetime
            replyDao.save(reply)
            feedback.replystatus = PortalConstant.YES
            feedbackDao.save(feedback)
            null
        } else {
            "回复的留言不存在"
        }
    }
}