package com.supwisdom.dlpay.portal.service.Impl

import com.supwisdom.dlpay.api.service.KafkaSendMsgService
import com.supwisdom.dlpay.framework.jpa.page.Pagination
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.mobile.dao.MsgDao
import com.supwisdom.dlpay.portal.bean.MsgTemplateSearchBean
import com.supwisdom.dlpay.portal.bean.SendMsgBean
import com.supwisdom.dlpay.portal.dao.MsgTemplateDao
import com.supwisdom.dlpay.portal.domain.TBMsgTemplate
import com.supwisdom.dlpay.portal.service.MsgService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import java.lang.RuntimeException
import java.util.regex.Pattern

@Service
class MsgServiceImpl : MsgService {
    @Autowired
    lateinit var msgTemplateDao: MsgTemplateDao
    @Autowired
    lateinit var msgDao: MsgDao
    @Autowired
    lateinit var systemUtilService: SystemUtilService
    @Autowired
    lateinit var kafkaSendMsgService: KafkaSendMsgService

    override fun getMsgTemplateList(bean: MsgTemplateSearchBean): Pagination {
        return msgTemplateDao.getMsgTemplateList(bean)
    }

    override fun saveMsgTemplate(template: TBMsgTemplate) {
        template.updatetime = systemUtilService.sysdatetime.hostdatetime
        msgTemplateDao.save(template)
    }

    override fun sendMsg(bean: SendMsgBean) {
        val optional = msgTemplateDao.findById(bean.templateid)
        if (optional.isPresent) {
            val template = optional.get()
            var content = template.content
            val data = bean.data
            //正则匹配所有${xx}
            val pattern: Pattern = Pattern.compile("\\$\\{[\\w]*}")
            val matcher = pattern.matcher(content)
            while (matcher.find()) {
                val source = matcher.group()
                //截取${}括号中的内容
                val param = source.substring(2, source.length - 1)
                if (data.containsKey(param)) {
                    val value = data[param].toString()
                    content = content.replace(source, value)
                } else {
                    throw RuntimeException("未设置参数<${param}>的值")
                }
            }
            kafkaSendMsgService.sendJpushMessage(bean.userid,template.title,content,bean.refno,mutableMapOf(),"")
        }else {
            throw RuntimeException("未找到id为：<${bean.templateid}>的模板，请确认模板id")
        }
    }
}