import request from '@/utils/request'

export function uploadImage(data) {
  return request({
    url: '/article/uploadpic',
    method: 'post',
    headers: {
      'content-type': 'multipart/form-data'
    },
    data
  })
}

export function saveArticle(data) {
  return request({
    url: '/article/save',
    method: 'post',
    data
  })
}

export function getArticleList(query) {
  return request({
    url: '/article/list',
    method: 'get',
    params: query
  })
}

export function getArticle(articleno) {
  return request({
    url: '/article/get/' + articleno,
    method: 'get'
  })
}

export function releaseArticle(data) {
  return request({
    url: '/article/release',
    method: 'post',
    data
  })
}

export function reviewArticle(data) {
  return request({
    url: '/article/review',
    method: 'post',
    data
  })
}

export function deleteArticle(articleno) {
  return request({
    url: '/article/delete/' + articleno,
    method: 'post'
  })
}

export function switchDisplay(articleno, value) {
  return request({
    url: '/article/switchdisplay/' + articleno,
    method: 'post',
    params: value
  })
}

export function fetchList(query) {
  return request({
    url: '/vue-element-admin/article/list',
    method: 'get',
    params: query
  })
}

export function fetchArticle(id) {
  return request({
    url: '/vue-element-admin/article/detail',
    method: 'get',
    params: { id }
  })
}

export function fetchPv(pv) {
  return request({
    url: '/vue-element-admin/article/pv',
    method: 'get',
    params: { pv }
  })
}

export function createArticle(data) {
  return request({
    url: '/vue-element-admin/article/create',
    method: 'post',
    data
  })
}

export function updateArticle(data) {
  return request({
    url: '/vue-element-admin/article/update',
    method: 'post',
    data
  })
}
