import { asyncRoutes, constantRoutes } from '@/router'
import { getAuthMenu } from '@/api/user'
import Layout from '@/layout'

/**
 * Use meta.role to determine if the current user has permission
 * @param roles
 * @param route
 */
function hasPermission(roles, route) {
  if (route.meta && route.meta.roles) {
    return roles.some(role => route.meta.roles.includes(role))
  } else {
    return true
  }
}

/**
 * 后台查询的菜单数据拼装成路由格式的数据
 * @param routes
 */
export function generaMenu(routes, data) {
  data.forEach(item => {
    // alert(JSON.stringify(item))
    if (item.respath === '/article/list') {
      const editArticle = {
        path: '/article/edit/:id(\\d+)',
        component: (resolve) => require([`@/views/article/edit`], resolve),
        name: 'EditArticle',
        meta: { title: '编辑文章', id: '1c039c677ded4f1dab63a4fa9c0a27ca', noCache: true, roles: ['admin'] },
        hidden: true
      }
      const examineArticle = {
        path: '/article/examine/:id(\\d+)',
        component: (resolve) => require([`@/views/article/examine`], resolve),
        name: 'ExamineArticle',
        meta: { title: '文章详情', id: '28d382221fdb44f49397f618c6cae3f7', noCache: true, roles: ['admin'] },
        hidden: true
      }
      routes.push(editArticle)
      routes.push(examineArticle)
    }
    const menu = {
      path: item.respath === '#' ? item.resid + '_key' : item.respath,
      component: item.respath === '#' ? Layout : (resolve) => require([`@/views${item.respath}`], resolve),
      // hidden: true,
      children: [],
      name: 'menu_' + item.resid,
      meta: { title: item.resname, id: item.resid, roles: ['admin'], icon: item.icon }
    }
    if (item.children) {
      generaMenu(menu.children, item.children)
    }
    routes.push(menu)
  })
}

/**
 * Filter asynchronous routing tables by recursion
 * @param routes asyncRoutes
 * @param roles
 */
export function filterAsyncRoutes(routes, roles) {
  const res = []

  routes.forEach(route => {
    const tmp = { ...route }
    if (hasPermission(roles, tmp)) {
      if (tmp.children) {
        tmp.children = filterAsyncRoutes(tmp.children, roles)
      }
      res.push(tmp)
    }
  })

  return res
}

const state = {
  routes: [],
  addRoutes: []
}

const mutations = {
  SET_ROUTES: (state, routes) => {
    state.addRoutes = routes
    state.routes = constantRoutes.concat(routes)
  }
}

const actions = {
  generateRoutes({ commit }, roles) {
    return new Promise(resolve => {
      const loadMenuData = []
      // 先查询后台并返回左侧菜单数据并把数据添加到路由
      getAuthMenu(state.token).then(response => {
        const data = response.resource
        Object.assign(loadMenuData, data)
        generaMenu(asyncRoutes, loadMenuData)
        let accessedRoutes
        if (roles.includes('admin')) {
          // alert(JSON.stringify(asyncRoutes))
          accessedRoutes = asyncRoutes || []
        } else {
          accessedRoutes = filterAsyncRoutes(asyncRoutes, roles)
        }
        commit('SET_ROUTES', accessedRoutes)
        resolve(accessedRoutes)

        // generaMenu(asyncRoutes, data)
      }).catch(error => {
        console.log(error)
      })
    })
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}
