// 自定义全局js
(function (root) {
    "use strict";

    root.DictPoolToolkit = function () {
        var storage = root.localStorage;
        if (storage == null || storage === undefined) {
            layer.msg("浏览器不支持 LocalStorage！！！", {icon: 2, time: 1000});
            return null;
        }

        return {
            url: "",
            storage: storage,
            pool: {},
            addNewDict: function (dictType) {
                var that = this;
                console.log("正在加载<" + dictType + ">");
                $.ajax(that.url, {
                        method: "GET",
                        data: "dicttype=" + dictType,
                        contentType: "application/x-www-form-urlencoded",
                        success: function (data) {
                            if (data == null || data === "") {
                                that.storage.removeItem(dictType);
                            } else {
                                that.storage.setItem(dictType, JSON.stringify(data));
                                console.log("<" + dictType + ">加载成功!");
                            }
                        },
                        error: function (e) {
                            console.log("<" + dictType + ">加载失败！");
                        }
                    }
                );
                return this;
            },
            loadSyncDict: function (dictType) {
                var that = this;
                console.log("正在加载<" + dictType + ">");
                $.ajax(that.url, {
                        method: "GET",
                        data: "dicttype=" + dictType,
                        async: false,  //同步
                        contentType: "application/x-www-form-urlencoded",
                        success: function (data) {
                            if (data == null || data == "") {
                                that.storage.removeItem(dictType);
                            } else {
                                that.storage.setItem(dictType, JSON.stringify(data));
                                console.log("<" + dictType + ">加载成功!");
                            }
                        },
                        error: function (e) {
                            console.log("<" + dictType + ">加载失败！");
                        }
                    }
                );
                return this;
            },
            initAll: function (url) {
                this.url = url;
                this.addNewDict("transtypeList")
                    .addNewDict("reverseFlagList")
                    .addNewDict("transtatusList")
                    .addNewDict("idtypeList")
                    .addNewDict("sexList")
                    .addNewDict("accountStatusList")
            },
            getDict: function (dictType) {
                var dict, that = this;
                if (that.pool[dictType] !== undefined) {
                    return that.pool[dictType];
                } else {
                    dict = that.storage.getItem(dictType);
                    if (dict === undefined) {
                        return null;
                    } else {
                        that.pool[dictType] = JSON.parse(dict);
                        return that.pool[dictType];
                    }
                }
            },
            getDictValue: function (dictType, code) {
                var dict, that = this;
                dict = that.getDict(dictType);
                if (dict == null) {
                    return code;
                } else {
                    var c = "" + code;
                    return dict[c] === undefined ? code : dict[c];
                }
            }
        }
    }

    root.getTempDictValue = function (dicttype, key) {
        return DictPoolToolkit().getDictValue(dicttype, key);
    }

    root.dateFormat = function (str) {
        return str.replace(/^(\d{4})(\d{2})(\d{2})$/, '$1-$2-$3'); //yyyyMMdd --> yyyy-MM-dd
    }
}(window));