package com.supwisdom.dlpay.api.bean;

import com.supwisdom.dlpay.framework.util.MD5;
import com.supwisdom.dlpay.framework.util.RandomUtils;

/**
 * Created by shuwei on 17/6/12.
 */
public class WechatReqResp {
    private int retcode;
    private String retmsg;

    private String nonce_str;
    private String appid;
    private String body;
    private String mch_id;
    private String openid;
    private String out_trade_no;
    private String spbill_create_ip;
    private String trade_type;
    private String key;
    private String sign;
    private int total_fee;
    private String timestamp;
    private String auth_code;

    private String out_refund_no;
    private int refund_fee;
    private String refund_desc;

    private String notify_url;
    private String prepay_id;
    private String wpackage;

    private String scene_info;

    private String mweb_url;

    public String getScene_info() {
        return scene_info;
    }

    public void setScene_info(String scene_info) {
        this.scene_info = scene_info;
    }

    public String getMweb_url() {
        return mweb_url;
    }

    public void setMweb_url(String mweb_url) {
        this.mweb_url = mweb_url;
    }

    public String getNonce_str() {
        return nonce_str;
    }

    public void setNonce_str(String nonce_str) {
        this.nonce_str = nonce_str;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getMch_id() {
        return mch_id;
    }

    public void setMch_id(String mch_id) {
        this.mch_id = mch_id;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getOut_trade_no() {
        return out_trade_no;
    }

    public void setOut_trade_no(String out_trade_no) {
        this.out_trade_no = out_trade_no;
    }

    public String getSpbill_create_ip() {
        return spbill_create_ip;
    }

    public void setSpbill_create_ip(String spbill_create_ip) {
        this.spbill_create_ip = spbill_create_ip;
    }

    public String getTrade_type() {
        return trade_type;
    }

    public void setTrade_type(String trade_type) {
        this.trade_type = trade_type;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public int getTotal_fee() {
        return total_fee;
    }

    public void setTotal_fee(int total_fee) {
        this.total_fee = total_fee;
    }

    public String getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getAuth_code() {
        return auth_code;
    }

    public void setAuth_code(String auth_code) {
        this.auth_code = auth_code;
    }


    public String getNotify_url() {
        return notify_url;
    }

    public void setNotify_url(String notify_url) {
        this.notify_url = notify_url;
    }

    public String getPrepay_id() {
        return prepay_id;
    }

    public void setPrepay_id(String prepay_id) {
        this.prepay_id = prepay_id;
    }

    public String getWpackage() {
        return wpackage;
    }

    public void setWpackage(String wpackage) {
        this.wpackage = wpackage;
    }

    public int getRetcode() {
        return retcode;
    }

    public void setRetcode(int retcode) {
        this.retcode = retcode;
    }

    public String getRetmsg() {
        return retmsg;
    }

    public void setRetmsg(String retmsg) {
        this.retmsg = retmsg;
    }

    public String getOut_refund_no() {
        return out_refund_no;
    }

    public void setOut_refund_no(String out_refund_no) {
        this.out_refund_no = out_refund_no;
    }

    public int getRefund_fee() {
        return refund_fee;
    }

    public void setRefund_fee(int refund_fee) {
        this.refund_fee = refund_fee;
    }

    public String getRefund_desc() {
        return refund_desc;
    }

    public void setRefund_desc(String refund_desc) {
        this.refund_desc = refund_desc;
    }

    public String generalPaySign() {
        this.nonce_str = RandomUtils.getRandomString(30);
        StringBuffer str = new StringBuffer()
                .append("appid=").append(this.appid)
                .append("&auth_code=").append(this.auth_code)
                .append("&body=").append(this.body)
                .append("&mch_id=").append(this.mch_id)
                .append("&nonce_str=").append(nonce_str)
                .append("&out_trade_no=").append(this.out_trade_no)
                .append("&spbill_create_ip=").append(this.spbill_create_ip)
                .append("&total_fee=").append(this.total_fee)
                ;
        str.append("&key=").append(this.key);
        this.sign = MD5.encodeByMD5(str.toString());
        return sign;
    }
    public String generalCheckSign(){
        this.nonce_str = RandomUtils.getRandomString(30);
        StringBuffer str = new StringBuffer()
                .append("appid=").append(this.appid)
                .append("&auth_code=").append(this.auth_code)
                .append("&mch_id=").append(this.mch_id)
                .append("&nonce_str=").append(nonce_str);
        str.append("&key=").append(this.key);
        this.sign = MD5.encodeByMD5(str.toString());
        return sign;
    }
    public String generalCheckXML(){
        StringBuffer requestStr = new StringBuffer();
        requestStr
                .append("<xml>")
                .append("<appid>")
                .append(this.appid)
                .append("</appid>")
                .append("<auth_code>")
                .append(this.auth_code)
                .append("</auth_code>")
                .append("<mch_id>")
                .append(this.mch_id)
                .append("</mch_id>")
                .append("<nonce_str>")
                .append(this.nonce_str)
                .append("</nonce_str>")
        ;
        requestStr.append("<sign>")
                .append(this.sign)
                .append("</sign>")
                .append("</xml>");
        return requestStr.toString();
    }


    public String generaPayXML() {
        StringBuffer requestStr = new StringBuffer();
        requestStr
                .append("<xml>")
                .append("<appid>")
                .append(this.appid)
                .append("</appid>")
                .append("<auth_code>")
                .append(this.auth_code)
                .append("</auth_code>")
                .append("<body>")
                .append(this.body)
                .append("</body>")
                .append("<mch_id>")
                .append(this.mch_id)
                .append("</mch_id>")
                .append("<nonce_str>")
                .append(this.nonce_str)
                .append("</nonce_str>")
                .append("<out_trade_no>")
                .append(this.out_trade_no)
                .append("</out_trade_no>")
                .append("<spbill_create_ip>")
                .append(this.spbill_create_ip)
                .append("</spbill_create_ip>")
                .append("<total_fee>")
                .append(this.total_fee)
                .append("</total_fee>")
        ;

        requestStr.append("<sign>")
                .append(this.sign)
                .append("</sign>")
                .append("</xml>");
        return requestStr.toString();
    }
    public String generaSign() {
        this.nonce_str = RandomUtils.getRandomString(30);
        StringBuffer str = new StringBuffer()
                .append("appid=").append(this.appid)
                .append("&body=").append(this.body)
                .append("&mch_id=").append(this.mch_id)
                .append("&nonce_str=").append(nonce_str)
                .append("&notify_url=").append(this.notify_url);
        if ("JSAPI".equals(this.trade_type)) {
            str.append("&openid=").append(this.openid);
        }
        str.append("&out_trade_no=").append(this.out_trade_no);
        if ("MWEB".equals(this.trade_type)) {
            str.append("&scene_info=").append(this.scene_info);
        }
        str.append("&spbill_create_ip=").append(this.spbill_create_ip)
                .append("&total_fee=").append(this.total_fee)
                .append("&trade_type=").append(this.trade_type);
        str.append("&key=").append(this.key);
        this.sign = MD5.encodeByMD5(str.toString());
        return sign;
    }
    public String generaReverseSign() {
        this.nonce_str = RandomUtils.getRandomString(30);
        StringBuffer str = new StringBuffer()
                .append("appid=").append(this.appid)
                .append("&mch_id=").append(this.mch_id)
                .append("&nonce_str=").append(nonce_str)
                .append("&notify_url=").append(this.notify_url)
                .append("&out_refund_no=").append(this.out_refund_no)
                .append("&out_trade_no=").append(this.out_trade_no)
                .append("&refund_desc=").append(this.refund_desc)
                .append("&refund_fee=").append(this.refund_fee)
                .append("&total_fee=").append(this.total_fee)
                ;
        str.append("&key=").append(this.key);
        this.sign = MD5.encodeByMD5(str.toString());
        return sign;
    }
    public String generaXML() {
        StringBuffer requestStr = new StringBuffer();
        requestStr
                .append("<xml>")
                .append("<appid>")
                .append(this.appid)
                .append("</appid>")
                .append("<body>")
                .append(this.body)
                .append("</body>")
                .append("<mch_id>")
                .append(this.mch_id)
                .append("</mch_id>")
                .append("<nonce_str>")
                .append(this.nonce_str)
                .append("</nonce_str>")
                .append("<notify_url>")
                .append(this.notify_url)
                .append("</notify_url>")
                .append("<out_trade_no>")
                .append(this.out_trade_no)
                .append("</out_trade_no>")
                .append("<spbill_create_ip>")
                .append(this.spbill_create_ip)
                .append("</spbill_create_ip>")
                .append("<total_fee>")
                .append(this.total_fee)
                .append("</total_fee>")
                .append("<trade_type>")
                .append(this.trade_type)
                .append("</trade_type>")
        ;
        if ("JSAPI".equals(this.trade_type)) {
            requestStr.append("<openid>")
                    .append(this.openid)
                    .append("</openid>");
        }
        if ("MWEB".equals(this.trade_type)) {
            requestStr.append("<scene_info>")
                    .append(this.scene_info)
                    .append("</scene_info>");
        }
        requestStr.append("<sign>")
                .append(this.sign)
                .append("</sign>")
                .append("</xml>");
        return requestStr.toString();
    }

    public String generaReverseXML() {
        StringBuffer requestStr = new StringBuffer();
        requestStr
                .append("<xml>")
                .append("<appid>")
                .append(this.appid)
                .append("</appid>")
                .append("<mch_id>")
                .append(this.mch_id)
                .append("</mch_id>")
                .append("<nonce_str>")
                .append(this.nonce_str)
                .append("</nonce_str>")
                .append("<notify_url>")
                .append(this.notify_url)
                .append("</notify_url>")
                .append("<out_refund_no>")
                .append(this.out_refund_no)
                .append("</out_refund_no>")
                .append("<out_trade_no>")
                .append(this.out_trade_no)
                .append("</out_trade_no>")
                .append("<refund_desc>")
                .append(this.refund_desc)
                .append("</refund_desc>")
                .append("<refund_fee>")
                .append(this.refund_fee)
                .append("</refund_fee>")
                .append("<total_fee>")
                .append(this.total_fee)
                .append("</total_fee>")
        ;
        requestStr.append("<sign>")
                .append(this.sign)
                .append("</sign>")
                .append("</xml>");
        return requestStr.toString();
    }


    public String generaAPPSign() {
        String signTemp = "appid=" + this.appid
                + "&nonce_str=" + this.nonce_str
                + "&package=" + this.wpackage
                + "&partnerid=" + this.mch_id
                + "&prepayid=" + this.prepay_id
                + "&timestamp=" + this.timestamp
                + "&key=" + this.key;
        this.sign = MD5.encodeByMD5(signTemp);
        return sign;
    }

    public String generaJSAPISign() {
        String signTemp = "appId=" + this.appid
                + "&nonceStr=" + this.nonce_str
                + "&package=prepay_id=" + this.prepay_id
                + "&signType=MD5"
                + "&timeStamp=" + this.timestamp
                + "&key=" + this.key;
        this.sign = MD5.encodeByMD5(signTemp);
        return sign;
    }

    public String generaJSAPIParamters() {
        String json = "{\"appId\":\"" + this.appid + "\","
                + "\"nonceStr\":\"" + this.nonce_str + "\","
                + "\"packages\":\"prepay_id=" + this.prepay_id + "\","
                + "\"signType\":\"MD5\","
                + "\"timeStamp\":\"" + this.timestamp + "\","
                + "\"paySign\":\"" + this.sign + "\"}";
        return json;
    }
}
