package com.supwisdom.dlpay.api.domain;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * Created by shuwei on 2019/4/9.
 */
@Embeddable
public class TPaytypeConfigPK implements Serializable {
    @Id
    @Column(name = "PAYTYPE", nullable = false, length = 20)
    private String paytype;
    @Id
    @Column(name = "CONFIGID", nullable = false, length = 40)
    private String configid;

    public String getPaytype() {
        return paytype;
    }

    public void setPaytype(String paytype) {
        this.paytype = paytype;
    }

    public String getConfigid() {
        return configid;
    }

    public void setConfigid(String configid) {
        this.configid = configid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TPaytypeConfigPK that = (TPaytypeConfigPK) o;

        if (!paytype.equals(that.paytype)) return false;
        return configid.equals(that.configid);
    }

    @Override
    public int hashCode() {
        int result = paytype.hashCode();
        result = 31 * result + configid.hashCode();
        return result;
    }
}
