package com.supwisdom.dlpay.api.domain;

import com.supwisdom.dlpay.framework.domain.TPerson;

import javax.persistence.*;

@Entity
@Table(name = "TB_PERSON_IDENTITY")
public class TPersonIdentity {
  //  市民卡号
  @Id
  @Column(name = "THIRD_UID", nullable = false, length = 60)
  private String thirdUid;

  @Column(name = "CARDPHYID",length = 60)
  private String cardphyId;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "USERID")
  private TPerson person; //绑定的系统用户

  @Column(name = "STATUS", nullable = false, length = 20)
  private String status;

  @Column(name = "LOSSFLAG",nullable = false, precision = 1)
  private Integer lossflag=0;

  @Column(name = "LOCKFLAG", nullable = false, precision = 1)
  private Integer lockflag=0;

  @Column(name = "CREATETIME", length = 14)
  private String createtime;

  @Column(name = "COAMOUNT",precision = 10, scale = 2)
  private Double coamount;

  @Column(name = "ACCAMOUNT",precision = 10, scale = 2)
  private Double accamount;

  public Double getCoamount() {
    return coamount;
  }

  public void setCoamount(Double coamount) {
    this.coamount = coamount;
  }

  public Double getAccamount() {
    return accamount;
  }

  public void setAccamount(Double accamount) {
    this.accamount = accamount;
  }

  public TPersonIdentity() {
  }

  public TPersonIdentity(String thirdUid, TPerson person, String status, Integer lossflag, Integer lockflag, String createtime,String cardphyId,Double coamount,Double accamount) {
    this.thirdUid = thirdUid;
    this.person = person;
    this.status = status;
    this.lossflag = lossflag;
    this.lockflag = lockflag;
    this.createtime = createtime;
    this.cardphyId = cardphyId;
    this.coamount = coamount;
    this.accamount = accamount;
  }

  public String getCardphyId() {
    return cardphyId;
  }

  public void setCardphyId(String cardphyId) {
    this.cardphyId = cardphyId;
  }

  public String getThirdUid() {
    return thirdUid;
  }

  public void setThirdUid(String thirdUid) {
    this.thirdUid = thirdUid;
  }

  public TPerson getPerson() {
    return person;
  }

  public void setPerson(TPerson person) {
    this.person = person;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Integer getLossflag() {
    return lossflag;
  }

  public void setLossflag(Integer lossflag) {
    this.lossflag = lossflag;
  }

  public Integer getLockflag() {
    return lockflag;
  }

  public void setLockflag(Integer lockflag) {
    this.lockflag = lockflag;
  }

  public String getCreatetime() {
    return createtime;
  }

  public void setCreatetime(String createtime) {
    this.createtime = createtime;
  }

}
