package com.supwisdom.dlpay.api.domain;

import com.supwisdom.dlpay.framework.domain.TPerson;
import com.supwisdom.dlpay.framework.util.MD5;

import javax.persistence.*;

/**
 * 积分账户表
 */
@Entity
@Table(name = "TB_POINTS_ACCOUNT")
public class TPointsAccount {
  @Id
  @Column(name = "USERID", nullable = false, length = 32)
  private String userid;

  @Column(name = "POINTS", nullable = false, precision = 15)
  private Long points; //积分

  @Column(name = "ACCUMPOINTS", precision = 15)
  private Long accumPoints; //历史累计获取的积分

  @Column(name = "SUMPAYPOINTS", precision = 15)
  private Long sumpayPoints; //历史累计消费的积分

  @Column(name = "TAC", precision = 15)
  private String tac;

  @Column(name = "LASTSAVED", precision = 15)
  private String lastsaved;

  @OneToOne
  @JoinColumn(name = "USERID",insertable = false,updatable = false)
  private TPerson person;

  public TPerson getPerson() {
    return person;
  }

  public void setPerson(TPerson person) {
    this.person = person;
  }

  public TPointsAccount() {
  }

  public TPointsAccount(String userid, Long points, Long accumPoints, Long sumpayPoints, String tac, String lastsaved) {
    this.userid = userid;
    this.points = points;
    this.accumPoints = accumPoints;
    this.sumpayPoints = sumpayPoints;
    this.tac = tac;
    this.lastsaved = lastsaved;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public Long getPoints() {
    return points;
  }

  public void setPoints(Long points) {
    this.points = points;
  }

  public Long getAccumPoints() {
    return accumPoints;
  }

  public void setAccumPoints(Long accumPoints) {
    this.accumPoints = accumPoints;
  }

  public Long getSumpayPoints() {
    return sumpayPoints;
  }

  public void setSumpayPoints(Long sumpayPoints) {
    this.sumpayPoints = sumpayPoints;
  }

  public String getTac() {
    return tac;
  }

  public void setTac(String tac) {
    this.tac = tac;
  }

  public String getLastsaved() {
    return lastsaved;
  }

  public void setLastsaved(String lastsaved) {
    this.lastsaved = lastsaved;
  }

  public String generateTac() {
    String data = this.userid + this.points;
    return MD5.generatePassword(data, this.userid);
  }

  public boolean tacCheck() {
    String tac_c = generateTac();
    if (tac_c.equalsIgnoreCase(this.tac) || this.tac == null) {
      return true;
    }
    return false;
  }

  public void addPoints(int points) {
    this.points = this.points + points;
    if (points > 0) {
      this.accumPoints = ((this.accumPoints == null ? 0 : this.accumPoints) + Math.abs(points)); //获得积分累加
    } else {
      this.sumpayPoints = ((this.sumpayPoints == null ? 0 : this.sumpayPoints) + Math.abs(points)); //消费积分累加
    }
    this.tac = this.generateTac();
  }

  public void addPoints(int points, boolean revflag) {
    if (revflag) {
      //冲正返回积分
      this.points = this.points + points;
      if (points > 0) {
        this.sumpayPoints = ((this.sumpayPoints == null ? 0 : this.sumpayPoints) - Math.abs(points)); //消费积分累计冲正
      } else {
        this.accumPoints = ((this.accumPoints == null ? 0 : this.accumPoints) - Math.abs(points)); //获得积分累计冲正
      }
      this.tac = this.generateTac();
    } else {
      this.addPoints(points);
    }
  }


}
