package com.supwisdom.dlpay.api.domain;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Id;
import java.io.Serializable;

@Embeddable
public class TShopPaytypePK implements Serializable {
  @Id
  @Column(name = "SHOPACCNO", nullable = false, length = 10)
  private String shopaccno;

  @Id
  @Column(name = "PAYTYPE", nullable = false, length = 20)
  private String paytype;

  public TShopPaytypePK() {
  }

  public TShopPaytypePK(String shopaccno, String paytype) {
    this.shopaccno = shopaccno;
    this.paytype = paytype;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getPaytype() {
    return paytype;
  }

  public void setPaytype(String paytype) {
    this.paytype = paytype;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TShopPaytypePK tShopPaytypePK = (TShopPaytypePK) o;
    if (shopaccno != null ? !shopaccno.equals(tShopPaytypePK.getShopaccno()) : shopaccno != null)
      return false;
    if (paytype != null ? !paytype.equals(tShopPaytypePK.getPaytype()) : paytype != null)
      return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = shopaccno != null ? shopaccno.hashCode() : 0;
    result = 31 * result + (paytype != null ? paytype.hashCode() : 0);
    return result;
  }
}
