package com.supwisdom.dlpay.api.service.impl;

import com.supwisdom.dlpay.api.dao.PaytypeConfigDao;
import com.supwisdom.dlpay.api.dao.SourceTypeDao;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.api.domain.TPaytypeConfig;
import com.supwisdom.dlpay.api.service.SourceTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by shuwei on 2019/4/9.
 */
@Service
@CacheConfig(cacheNames = "sourcetypeCache")
public class SourceTypeServiceImpl implements SourceTypeService {
  @Autowired
  private SourceTypeDao paytypeDao;
  @Autowired
  private PaytypeConfigDao paytypeConfigDao;

  @Override
  @Cacheable
  public TSourceType getByPaytype(String paytype) {
    return paytypeDao.getOne(paytype);
  }

  @Override
  @Cacheable
  public Map<String, String> getPaytypeConfigByPaytype(String pattype) {
    List<TPaytypeConfig> list = paytypeConfigDao.getByPaytype(pattype);
    Map<String, String> map = new HashMap<>(list.size());
    for (TPaytypeConfig paytypeConfig : list) {
      map.put(paytypeConfig.getConfigid(), paytypeConfig.getConfigValue());
    }
    return map;
  }
}
