package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.NodeData;
import com.supwisdom.dlpay.framework.domain.TRoleFunction;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RoleFunctionDao extends JpaRepository<TRoleFunction, String> {

    TRoleFunction findByRoleIdAndFunctionId(String roleId, Integer functionId);

    void deleteByFunctionId(Integer functionId);

    List<TRoleFunction> findByRoleId(String roleId);

    @Query(value = "select tt.id,tt.pid,tt.name,tt.checked,tt.open from  " +
            " ( select f.id||'' as id ,f.parentid||'' as pid,f.name,case when rf.id is null then 0 else 1 end as checked,case when f.parentid=-1 then 1 else 0 end as open from tb_function f " +
            " left join tb_role_function rf on rf.functionid = f.id and rf.roleid=?1  " +
            " union all " +
            " select r.id||'_res' as id,r.function_id||'' as pid,r.name,case when p.id is null then 0 else 1 end as checked,0 as open from tb_resource  r " +
            " left join tb_permission p on p.resid = r.id and p.roleid=?1 ) tt order by tt.id " , nativeQuery = true)
    List<NodeData> findByRoleIdNative(String roleId);

    void deleteByRoleId(String roleId);
}
