package com.supwisdom.dlpay.framework.domain;

import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_APICLIENT")
public class TApiClient {
  @Id
  @Column(name = "appid", nullable = false, length = 20)
  private String appid;

  @Column(name = "secret", nullable = false, length = 64)
  private String secret;

  @Column(name = "status", nullable = false, length = 10)
  private String status;

  @Column(name = "roles", length = 300)
  private String roles;

  @Column(name = "BCRYPT_SECRET", nullable = false, length = 64)
  private String bcryptSecret;

  @Column(name = "THIRDURL", length = 200)
  private String thirdurl;


  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSecret() {
    return secret;
  }

  public void setSecret(String secret) {
    this.secret = secret;
    this.bcryptSecret = new BCryptPasswordEncoder().encode(secret);
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getRoles() {
    return roles;
  }

  public void setRoles(String roles) {
    this.roles = roles;
  }

  public String getBcryptSecret() {
    return bcryptSecret;
  }

  public String getThirdurl() {
    return thirdurl;
  }

  public void setThirdurl(String thirdurl) {
    this.thirdurl = thirdurl;
  }

}
