package com.supwisdom.dlpay.framework.domain;

import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.NumberUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.SysparaUtil;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "TB_SYSPARA")
public class TSyspara {
  @Id
  @Column(name = "PARAID", nullable = false, precision = 9)
  private Integer paraid;

  @Column(name = "PARAVAL", length = 100)
  private String paraval;

  @Column(name = "PARANAME", length = 90)
  private String paraname;

  @Column(name = "PARAUNIT", length = 20)
  private String paraunit;

  @Column(name = "VALUETYPE", length = 10)
  private String valueType = SysparaUtil.SYSPARA_VALUETYPE_STRING;

  @Column(name = "EDITFLAG", precision = 1)
  @NotNull
  private Integer editflag;

  @Column(name = "DISPLAYFLAG", length = 10)
  @NotNull
  private String displayflag;

  @Column(name = "REMARK", length = 240)
  private String remark;

  @Column(name = "LASTSAVED", length = 14)
  @NotNull
  private String lastsaved;

  public TSyspara() {
  }

  public TSyspara(Integer paraid, Integer editflag) {
    this.paraid = paraid;
    this.editflag = editflag;
  }

  public TSyspara(Integer paraid, String paraval, String paraname, String paraunit, String valueType, Integer editflag, String displayflag, String remark, String lastsaved) {
    this.paraid = paraid;
    this.paraval = paraval;
    this.paraname = paraname;
    this.paraunit = paraunit;
    this.valueType = valueType;
    this.editflag = editflag;
    this.displayflag = displayflag;
    this.remark = remark;
    this.lastsaved = lastsaved;
  }

  public Integer getParaid() {
    return paraid;
  }

  public void setParaid(Integer paraid) {
    this.paraid = paraid;
  }

  public String getParaval() {
    return paraval;
  }

  public void setParaval(String paraval) {
    this.paraval = paraval;
  }

  public String getParaname() {
    return paraname;
  }

  public void setParaname(String paraname) {
    this.paraname = paraname;
  }

  public String getParaunit() {
    return paraunit;
  }

  public void setParaunit(String paraunit) {
    this.paraunit = paraunit;
  }

  public String getValueType() {
    return valueType;
  }

  public void setValueType(String valueType) {
    this.valueType = valueType;
  }

  public Integer getEditflag() {
    return editflag;
  }

  public void setEditflag(Integer editflag) {
    this.editflag = editflag;
  }

  public String getDisplayflag() {
    return displayflag;
  }

  public void setDisplayflag(String displayflag) {
    this.displayflag = displayflag;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getLastsaved() {
    return lastsaved;
  }

  public void setLastsaved(String lastsaved) {
    this.lastsaved = lastsaved;
  }

  /**
   * 判断参数是否非法
   *
   * @return 非法 -> true; 合法 -> false
   */
  public boolean checkValueInvalid() {
    if (!StringUtil.isEmpty(this.paraval)) {
      if (SysparaUtil.SYSPARA_VALUETYPE_AMOUNT.equals(this.valueType) && !NumberUtil.isAmount(this.paraval)) {
        return true; //参数值非金额类型
      } else if (SysparaUtil.SYSPARA_VALUETYPE_DECIMAL.equals(this.valueType) && !NumberUtil.isDecimal(this.paraval)) {
        return true; //参数值非数值类型
      } else if (SysparaUtil.SYSPARA_VALUETYPE_NUMBER.equals(this.valueType) && !NumberUtil.isNumber(this.paraval)) {
        return true; //参数值非整数
      } else if (SysparaUtil.SYSPARA_VALUETYPE_SWITCH.equals(this.valueType) && !"1".equals(this.paraval) && !"0".equals(this.paraval)) {
        return true; //参数值非开关量 0/1
      } else if (SysparaUtil.SYSPARA_VALUETYPE_DATE.equals(this.valueType) && !DateUtil.checkDatetimeValid(this.paraval, "yyyyMMdd")) {
        return true; //参数值非日期格式
      } else if (SysparaUtil.SYSPARA_VALUETYPE_DATETIME.equals(this.valueType) && !DateUtil.checkDatetimeValid(this.paraval, "yyyyMMddHHmmss")) {
        return true; //参数值非日期时间格式
      }
    }
    return false; //默认字符串格式都合法
  }
}
