package com.supwisdom.dlpay.framework.security;

import com.supwisdom.dlpay.framework.domain.TOperator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

import java.util.Collection;

public class OperUtil {

  public static TOperator getCurrentOper() {
    Authentication au = SecurityContextHolder.getContext()
        .getAuthentication();
    if (au == null)
      return null;
    if (au.getPrincipal() == null)
      return null;
    if (au != null && au.getPrincipal() instanceof TOperator) {
      return (TOperator) au.getPrincipal();
    } else {
      TOperator oper = new TOperator();
      oper.setOpername(au.getPrincipal().toString());
      oper.setOperpwd(au.getCredentials() == null ? null : au
          .getCredentials().toString());
      return oper;
    }
  }

  public static String getCurrentOperid() {
    TOperator oper = getCurrentOper();
    if (oper == null)
      return null;
    return oper.getOperid() == null ? oper.getOpercode() : oper.getOperid();
  }

  public static boolean isLogined() {
    Authentication au = SecurityContextHolder.getContext()
        .getAuthentication();
    if (au == null)
      return false;
    if (au.getPrincipal() == null)
      return false;
    if (au.getPrincipal() instanceof TOperator)
      return true;
    return false;
  }

  public static boolean isAdmin() {
    TOperator loginOper = OperUtil.getCurrentOper();
    if (loginOper != null) {
      Collection<? extends GrantedAuthority> gas = loginOper.getAuthorities();
      if (gas == null) {
        return false;
      }
      boolean flag = false;
      for (GrantedAuthority grantedAuthority : gas) {
        if ("ROLE_ADMIN".equals(grantedAuthority.getAuthority())) {
          flag = true;
        }
      }
      return flag;
    } else {
      return false;
    }
  }

}
