package com.supwisdom.dlpay.framework.security.validate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.supwisdom.dlpay.framework.util.DateUtil;

import java.util.Date;


public class ValidateCode{

	private String code;
	
	private Date expireTime;

	public ValidateCode() {
		super();
	}

	public ValidateCode(String code, Date expireTime) {
		super();
		this.code = code;
		this.expireTime = expireTime;
	}

	public ValidateCode(String code, int expireTime) {
		super();
		this.code = code;
		this.expireTime = DateUtil.setMinutes(new Date(), expireTime);
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Date getExpireTime() {
		return expireTime;
	}

	public void setExpireTime(Date expireTime) {
		this.expireTime = expireTime;
	}

	@JsonIgnore
	public boolean isExpired() {
		return new Date().compareTo(expireTime) > 0;
	}

	@Override
	public String toString() {
		return "ValidateCode [code=" + code + ", expireTime=" + expireTime + "]";
	}
}
