package com.supwisdom.dlpay.framework.service;

import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.domain.TSyspara;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface SystemUtilService {

  /**
   * 取数据库日期
   */
  @Transactional
  SystemDateTime getSysdatetime();

  /**
   * 更新任务表
   */
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TTaskLock updateTaskLock(TTaskLock lock);

  /**
   * 取任务表
   */
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TTaskLock doLockTask(String taskcode, Integer minRecover, String remark);

  /**
   * 获取记账日期
   */
//  String getAccdate();

  /**
   * 获取流水号
   */
  String getRefno();

  /**
   * 按交易码取交易名称
   */
//  String getTranscodeName(int transocde, String defaultValue);


  /********************** 获取【系统参数】【业务参数】通用方法 **********************/
  String getSysparaValue(int paraid);

  String getSysparaValue(int paraid, String defaultValue);

  boolean getSysparaValueAsBoolean(int paraid);

  int getSysparaValueAsInt(int paraid, int defaultValue);

  double getSysparaValueAsDouble(int paraid, double defaultValue);

  TSyspara getSyspara(int paraid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TSyspara getSysparaValueForUpdate(int paraid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TSyspara getSysparaValueForUpdateNowait(int paraid);


  String getBusinessValue(String parakey);

  String getBusinessValue(String parakey, String defaultValue);

  TBusinesspara getBusiness(String parakey);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TBusinesspara getBusinessValueForUpdate(String parakey);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  TBusinesspara getBusinessValueForUpdateNowait(String parakey);

  /********************** 获取【系统参数】【业务参数】通用方法 **********************/


  String getSubsystemSignKey(String syscode);

}
