package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.framework.dao.BusinessparaDao;
import com.supwisdom.dlpay.framework.domain.TBusinesspara;
import com.supwisdom.dlpay.framework.service.BusinessparaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;


@Service
public class BusinessparaServiceImpl implements BusinessparaService {

    @Autowired
    private BusinessparaDao businessparaDao;

    @Override
    @Cacheable(cacheNames = "businesspara_cache", key = "#p0")
    public TBusinesspara findByParakey(String paraKey) {
        TBusinesspara tb = businessparaDao.findByParakey(paraKey);
        if (null == tb) {
            throw new RuntimeException("未找到业务参数" + paraKey + "对应的值");
        }
        return tb;
    }

    @Override
    @CacheEvict(cacheNames = "businesspara_cache", key = "#para.parakey")
    public TBusinesspara saveOrUpdatePara(TBusinesspara para) {
        return businessparaDao.save(para);
    }
}
