package com.supwisdom.dlpay.framework.tenant;

import lombok.extern.slf4j.Slf4j;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

@Configuration
@Slf4j
public class HibernateConfig {

  private final JpaProperties jpaProperties;

  private final HibernateProperties hibernateProperties;

  public HibernateConfig(@Autowired JpaProperties jpaProperties,
                         HibernateProperties hibernateProperties) {
    this.jpaProperties = jpaProperties;
    this.hibernateProperties = hibernateProperties;
  }

  @Bean
  public JpaVendorAdapter getJpaVendorAdapter() {
    HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
    adapter.setGenerateDdl(true);
    return adapter;
  }

  @Bean("entityManagerFactory")
  public LocalContainerEntityManagerFactoryBean entityManagerFactoryBean(DataSource dataSource,
                                                                         MultiTenantConnectionProvider multiTenantConnectionProvider,
                                                                         CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
    Map<String, Object> properties = new HashMap<>();
    properties.putAll(hibernateProperties
        .determineHibernateProperties(jpaProperties.getProperties(),
            new HibernateSettings()));
    properties.put(Environment.MULTI_TENANT, MultiTenancyStrategy.SCHEMA);
    properties.put(Environment.MULTI_TENANT_CONNECTION_PROVIDER, multiTenantConnectionProvider);
    properties.put(Environment.MULTI_TENANT_IDENTIFIER_RESOLVER, currentTenantIdentifierResolver);

    LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
    em.setDataSource(dataSource);
    em.setPackagesToScan("com.supwisdom");
    em.setJpaPropertyMap(properties);
    em.setJpaVendorAdapter(getJpaVendorAdapter());
//    log.info("setup multi-tenant entityManagerFactor");
    return em;
  }

}
