package com.supwisdom.dlpay.framework.tenant;

import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * Created by shuwei on 2018/12/4.
 */
@Component
public class MultiTenantConnectionProviderImpl implements MultiTenantConnectionProvider {
  @Autowired
  private DataSource dataSource;

  @Override
  public Connection getAnyConnection() throws SQLException {
    return dataSource.getConnection();
  }

  @Override
  public void releaseAnyConnection(Connection connection) throws SQLException {
    connection.close();
  }

  @Override
  public Connection getConnection(String ti) throws SQLException {
    String tenantIdentifier = TenantContext.getTenantSchema();
    final Connection connection = getAnyConnection();
    try {
      if (tenantIdentifier != null) {
        connection.createStatement().execute("SET search_path = \"" + tenantIdentifier + "\", public");
      } else {
        connection.createStatement().execute("SET search_path =  public");
      }
    } catch (SQLException e) {
      throw new HibernateException("Problem setting schema to " + tenantIdentifier, e);
    }
    return connection;
  }

  @Override
  public void releaseConnection(String tenantIdentifier, Connection connection) throws SQLException {
    connection.close();
  }

  @Override
  public boolean supportsAggressiveRelease() {
    return false;
  }

  @SuppressWarnings("rawtypes")
  @Override
  public boolean isUnwrappableAs(Class unwrapType) {
    return false;
  }

  @Override
  public <T> T unwrap(Class<T> unwrapType) {
    return null;
  }
}
